/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.command.tardim;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.common.data.DimensionMapReloadListener;
import com.swdteam.common.init.TRDSounds;
import com.swdteam.common.item.ItemTardim;
import com.swdteam.main.Config;
import com.swdteam.main.Tardim;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CommandTravel
extends CommandTardimBase {
    @Override
    public void execute(String[] args, Player player, BlockPos pos, CommandTardimBase.CommandSource source) {
        TardimData data = TardimManager.getFromPos(pos);
        if (data != null) {
            if (data.hasPermission(player)) {
                if (args.length >= 3) {
                    try {
                        int x = Integer.parseInt(args[0]);
                        int y = Integer.parseInt(args[1]);
                        int z = Integer.parseInt(args[2]);
                        if (data.getTravelLocation() == null) {
                            data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                        }
                        data.getTravelLocation().setPosition(x, y, z);
                    }
                    catch (Exception e) {
                        CommandTravel.sendResponse(player, "Invalid coordinates, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                    }
                }
                if (args.length >= 4) {
                    Object dimension = "";
                    for (int i = 3; i < args.length; ++i) {
                        dimension = (String)dimension + args[i] + (i == args.length - 1 ? "" : " ");
                    }
                    dimension = DimensionMapReloadListener.toTitleCase((String)dimension);
                    String key = dimension;
                    if (TardimManager.DIMENSION_MAP.containsKey(dimension)) {
                        key = TardimManager.DIMENSION_MAP.get(dimension);
                    }
                    if (!CommandTravel.isValidPath(key)) {
                        CommandTravel.sendResponse(player, "Invalid dimension, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                    } else {
                        ResourceKey r = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)new ResourceLocation(key));
                        if (player.m_20194_().m_129880_(r) != null) {
                            if (data.getTravelLocation() == null) {
                                data.setTravelLocation(new TardimData.Location(data.getCurrentLocation().getPos(), (ResourceKey<Level>)r));
                            } else {
                                data.setTravelLocation(data.getTravelLocation().setLocation((ResourceKey<Level>)r));
                            }
                        } else {
                            CommandTravel.sendResponse(player, "Invalid dimension, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    }
                }
                if (data.isInFlight()) {
                    if (data.getTimeEnteredFlight() < System.currentTimeMillis() / 1000L - 10L) {
                        TardimData.Location loc = data.getTravelLocation();
                        ServerLevel level = player.m_20194_().m_129880_(loc.getLevel());
                        level.m_46865_(loc.getPos());
                        BlockPos landingPosButBetter = CommandTravel.getLandingPosition((Level)level, loc.getPos());
                        boolean recalc = false;
                        double fuel = data.calculateFuelForJourney((Level)player.m_20194_().m_129880_(data.getCurrentLocation().getLevel()), (Level)level, data.getCurrentLocation().getPos(), loc.getPos());
                        if (data.getFuel() >= fuel) {
                            BlockPos pos2;
                            int jj;
                            for (jj = 0; jj < 32; ++jj) {
                                if (Block.m_49936_((BlockGetter)level, (BlockPos)landingPosButBetter.m_7495_()) || !Block.m_49936_((BlockGetter)level, (BlockPos)(landingPosButBetter = CommandTravel.getLandingPosition((Level)level, pos2 = landingPosButBetter.m_142082_(level.f_46441_.nextInt(10) * (level.f_46441_.nextBoolean() ? 1 : -1), 0, level.f_46441_.nextInt(10) * (level.f_46441_.nextBoolean() ? 1 : -1)))).m_7495_())) continue;
                                recalc = true;
                                break;
                            }
                            if (!recalc) {
                                for (jj = 0; jj < 32; ++jj) {
                                    if (Block.m_49936_((BlockGetter)level, (BlockPos)landingPosButBetter.m_7495_()) || !Block.m_49936_((BlockGetter)level, (BlockPos)(landingPosButBetter = CommandTravel.getLandingPosition((Level)level, pos2 = landingPosButBetter.m_142082_(level.f_46441_.nextInt(30) * (level.f_46441_.nextBoolean() ? 1 : -1), 0, level.f_46441_.nextInt(30) * (level.f_46441_.nextBoolean() ? 1 : -1)))).m_7495_())) continue;
                                    recalc = true;
                                    break;
                                }
                            }
                            if (!recalc) {
                                for (jj = 0; jj < 32; ++jj) {
                                    if (Block.m_49936_((BlockGetter)level, (BlockPos)landingPosButBetter.m_7495_()) || !Block.m_49936_((BlockGetter)level, (BlockPos)(landingPosButBetter = CommandTravel.getLandingPosition((Level)level, pos2 = landingPosButBetter.m_142082_(level.f_46441_.nextInt(30) * (level.f_46441_.nextBoolean() ? 1 : -1), 0, level.f_46441_.nextInt(30) * (level.f_46441_.nextBoolean() ? 1 : -1)))).m_7495_())) continue;
                                    recalc = true;
                                    break;
                                }
                            }
                            if (Block.m_49936_((BlockGetter)level, (BlockPos)landingPosButBetter.m_7495_())) {
                                loc.setPosition(landingPosButBetter.m_123341_(), landingPosButBetter.m_123342_(), landingPosButBetter.m_123343_());
                                if (Tardim.isPosValid((Level)level, loc.getPos())) {
                                    ItemTardim.buildTardim((Level)level, loc.getPos(), data.getTravelLocation().getFacing(), data.getId());
                                    data.setCurrentLocation(data.getTravelLocation());
                                    data.setTravelLocation(null);
                                    data.setInFlight(false);
                                    data.addFuel(-fuel);
                                    data.save();
                                    if (!recalc) {
                                        CommandTravel.sendResponse(player, "TARDIM is landing", CommandTardimBase.ResponseType.COMPLETE, source);
                                    } else {
                                        CommandTravel.sendResponse(player, "Landing recalculated due to obstruction", CommandTardimBase.ResponseType.INFO, source);
                                        CommandTravel.sendResponse(player, "TARDIM is landing", CommandTardimBase.ResponseType.COMPLETE, source);
                                    }
                                    player.f_19853_.m_5594_(null, pos, (SoundEvent)TRDSounds.TARDIM_LANDING.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                                } else {
                                    CommandTravel.sendResponse(player, "TARDIM landing obstructed. Aborting...", CommandTardimBase.ResponseType.FAIL, source);
                                }
                            } else {
                                CommandTravel.sendResponse(player, "TARDIM landing obstructed. Aborting...", CommandTardimBase.ResponseType.FAIL, source);
                            }
                        } else {
                            CommandTravel.sendResponse(player, "Not enough fuel for journey", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    } else {
                        CommandTravel.sendResponse(player, "TARDIM is still taking off", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    TardimData.Location loc = data.getCurrentLocation();
                    ServerLevel level = player.m_20194_().m_129880_(loc.getLevel());
                    ItemTardim.destroyTardim((Level)level, loc.getPos(), Direction.NORTH);
                    data.setInFlight(true);
                    if (data.getTravelLocation() == null) {
                        data.setTravelLocation(data.getCurrentLocation());
                    }
                    data.setTimeEnteredFlight();
                    data.save();
                    CommandTravel.sendResponse(player, "TARDIM is taking off", CommandTardimBase.ResponseType.COMPLETE, source);
                    player.f_19853_.m_5594_(null, pos, (SoundEvent)TRDSounds.TARDIM_TAKEOFF.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
            } else {
                CommandTravel.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "travel";
    }

    @Override
    public String getUsage() {
        return "/travel (x, y, z) (dimension)";
    }

    public static BlockPos getLandingPosition(Level worldIn, BlockPos pos) {
        BlockPos topPos;
        int y = pos.m_123342_();
        BlockPos downPos = null;
        BlockPos upPos = null;
        for (int i = worldIn.m_141937_() + 1; i < y; ++i) {
            BlockPos pos2 = pos.m_142082_(0, -i, 0);
            if (!CommandTravel.canLandOnBlock(worldIn, pos2)) continue;
            downPos = new BlockPos(pos2.m_123341_(), pos2.m_123342_(), pos.m_123343_());
            break;
        }
        int worldHeight = worldIn.m_141928_() - 3;
        if (Config.INSTANCE.shouldUseNetherHeight()) {
            worldHeight = 125;
        }
        for (int i = 1; i < worldHeight - y; ++i) {
            BlockPos pos2 = pos.m_142082_(0, i, 0);
            if (!CommandTravel.canLandOnBlock(worldIn, pos2)) continue;
            upPos = new BlockPos(pos2.m_123341_(), pos2.m_123342_(), pos.m_123343_());
            break;
        }
        if (upPos == null && CommandTravel.canLandOnBlock(worldIn, topPos = new BlockPos(pos.m_123341_(), worldHeight, pos.m_123343_()))) {
            upPos = new BlockPos(topPos.m_123341_(), topPos.m_123342_(), topPos.m_123343_());
        }
        BlockPos use = pos;
        if (downPos == null && upPos != null) {
            use = upPos;
        }
        if (downPos != null && upPos == null) {
            use = downPos;
        }
        if (downPos != null && upPos != null) {
            double distanceUp = pos.m_123331_(upPos);
            double distanceDown = pos.m_123331_((Vec3i)downPos);
            use = distanceDown <= distanceUp ? downPos : upPos;
        }
        return new BlockPos(use.m_123341_(), use.m_123342_() + 1, use.m_123343_());
    }

    public static boolean canLandOnBlock(Level world, BlockPos pos) {
        return Block.m_49936_((BlockGetter)world, (BlockPos)pos) && Tardim.isPosValid(world, pos.m_7494_());
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }

    public static boolean isValidPath(String p_135842_) {
        return ResourceLocation.m_135830_((String)p_135842_);
    }
}

