/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.swdteam.main.Tardim;
import com.swdteam.tardim.TardimManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DimensionMapReloadListener
extends SimpleJsonResourceReloadListener {
    public DimensionMapReloadListener(Gson p_10768_, String p_10769_) {
        super(p_10768_, p_10769_);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        TardimManager.DIMENSION_MAP.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            DimensionMap dimMap = (DimensionMap)Tardim.GSON.fromJson(entry.getValue(), DimensionMap.class);
            if (dimMap == null || dimMap.getDimensionKey() == null || dimMap.getDimensionTranslations() == null) continue;
            for (String s : dimMap.getDimensionTranslations()) {
                TardimManager.DIMENSION_MAP.put(DimensionMapReloadListener.toTitleCase(s), dimMap.dimension_key);
            }
        }
    }

    public static String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder(input.length());
        boolean nextTitleCase = true;
        for (char c : input.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    public static class DimensionMap {
        private String dimension_key;
        private String[] dimension_translations;

        public String getDimensionKey() {
            return this.dimension_key;
        }

        public String[] getDimensionTranslations() {
            return this.dimension_translations;
        }
    }
}

