/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.swdteam.common.RegistryHandler;
import com.swdteam.common.block.BlockTardimDoors;
import com.swdteam.common.block.BlockTardimFloor;
import com.swdteam.common.block.BlockTardimRoof;
import com.swdteam.common.block.ITardimPart;
import com.swdteam.common.data.DimensionMapReloadListener;
import com.swdteam.common.data.FuelMapReloadListener;
import com.swdteam.common.event.BuildEventHandler;
import com.swdteam.common.init.CommandManager;
import com.swdteam.common.init.TRDDimensions;
import com.swdteam.main.Config;
import com.swdteam.main.proxy.ClientProxy;
import com.swdteam.main.proxy.ServerProxy;
import com.swdteam.network.NetworkHandler;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimIDMap;
import com.swdteam.tardim.TardimManager;
import com.swdteam.tardim.TardimSaveHandler;
import com.swdteam.util.world.Schematic;
import com.swdteam.util.world.SchematicUtils;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tardim")
public class Tardim {
    public static Random RANDOM = new Random();
    public static String VERSION = "1.1.2";
    public static Tardim INSTANCE;
    public static final Logger LOGGER;
    public static final Gson GSON;
    public static final ServerProxy PROXY;
    public static final String MODID = "tardim";
    public static Schematic TARDIM_INTERIOR;

    public Tardim() {
        INSTANCE = this;
        Config.load();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RegistryHandler.init();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::runLater);
        this.bothSideSetup(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(BuildEventHandler.class);
    }

    private void bothSideSetup(IEventBus modEventBus) {
        CommandManager.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    private void runLater(ParallelDispatchEvent event) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PROXY.doServerStuff(event);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PROXY.doClientStuff(event);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        TardimSaveHandler.SERVER = event.getServer();
        TardimManager.getCache().clear();
        try {
            TardimIDMap.load(event.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TARDIM_INTERIOR = SchematicUtils.loadSchematic("interior", SchematicUtils.FileLocation.INTERNAL);
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new DimensionMapReloadListener(GSON, "tardim_dimension_lookup"));
        event.addListener((PreparableReloadListener)new FuelMapReloadListener(GSON, "tardim_fuel"));
    }

    @SubscribeEvent
    public void onServerStarting(WorldEvent.Save event) {
        try {
            TardimIDMap.save(event.getWorld().m_142572_());
            Map<Integer, TardimData> data = TardimManager.getCache();
            for (Map.Entry<Integer, TardimData> entry : data.entrySet()) {
                entry.getValue().save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel && ((ServerLevel)event.getWorld()).m_46472_() == TRDDimensions.TARDIS) {
            try {
                TardimSaveHandler.loadInteriorBounds(event.getWorld().m_142572_());
            }
            catch (Exception e) {
                e.printStackTrace();
                TardimManager.INTERIOR_BOUNDS = Config.INSTANCE.getInteriorBounds();
            }
        }
    }

    public static boolean isPosValid(Level level, BlockPos pos) {
        return Tardim.validPos(level, pos) && Tardim.validPos(level, pos.m_7494_()) && Tardim.validPos(level, pos.m_7494_().m_7494_()) && Tardim.validPos(level, pos.m_142127_()) && Tardim.validPos(level, pos.m_142127_().m_7494_()) && Tardim.validPos(level, pos.m_142128_()) && Tardim.validPos(level, pos.m_142128_().m_7494_()) && Tardim.validPos(level, pos.m_142126_()) && Tardim.validPos(level, pos.m_142126_().m_7494_()) && Tardim.validPos(level, pos.m_142125_()) && Tardim.validPos(level, pos.m_142125_().m_7494_());
    }

    private static boolean validPos(Level l, BlockPos pos) {
        BlockState blockstate = l.m_8055_(pos);
        if (blockstate.m_60767_() == Material.f_76302_ || blockstate.m_60767_() == Material.f_76300_ || blockstate.m_60734_() == Blocks.f_50125_) {
            return true;
        }
        return blockstate.m_60795_();
    }

    public BlockPos getCenter(Level level, BlockPos pos) {
        BlockPos centerPos = null;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof ITardimPart) {
            if (state.m_60734_() instanceof BlockTardimDoors) {
                boolean upper = state.m_61143_(BlockTardimDoors.HALF) == DoubleBlockHalf.UPPER;
                Direction dir = (Direction)state.m_61143_((Property)BlockTardimDoors.FACING);
                centerPos = pos.m_142300_(dir).m_142082_(0, upper ? -1 : 0, 0);
            } else if (state.m_60734_() instanceof BlockTardimRoof) {
                centerPos = pos.m_7495_().m_7495_();
            } else if (state.m_60734_() instanceof BlockTardimFloor) {
                centerPos = pos;
            }
        }
        return centerPos;
    }

    public boolean isDamaged(Level level, BlockPos pos) {
        BlockPos centerPos = this.getCenter(level, pos);
        if (centerPos == null) {
            return true;
        }
        boolean doorsIntact = level.m_8055_(centerPos.m_142127_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_142128_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_142125_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_142126_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_7494_().m_142127_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_7494_().m_142128_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_7494_().m_142125_()).m_60734_() instanceof BlockTardimDoors && level.m_8055_(centerPos.m_7494_().m_142126_()).m_60734_() instanceof BlockTardimDoors;
        boolean roofIntact = level.m_8055_(centerPos.m_7494_().m_7494_()).m_60734_() instanceof BlockTardimRoof;
        boolean floorIntact = level.m_8055_(centerPos).m_60734_() instanceof BlockTardimFloor;
        return !doorsIntact || !roofIntact || !floorIntact;
    }

    static {
        LOGGER = LogManager.getLogger();
        GSON = new GsonBuilder().setPrettyPrinting().create();
        PROXY = (ServerProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    }
}

