/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.common.command.tardim.CommandTardimBase;
import com.swdteam.common.command.tardim.ICommand;
import com.swdteam.common.init.CommandManager;
import com.swdteam.common.init.TRDDimensions;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketExecuteCommand {
    public BlockPos pos;
    public String command;

    public PacketExecuteCommand(String command, BlockPos pos) {
        this.pos = pos;
        this.command = command;
    }

    public static void encode(PacketExecuteCommand msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.command);
        buf.m_130064_(msg.pos);
    }

    public static PacketExecuteCommand decode(FriendlyByteBuf buf) {
        return new PacketExecuteCommand(buf.m_130277_(), buf.m_130135_());
    }

    public static void handle(PacketExecuteCommand msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getNetworkManager().getDirection() == PacketFlow.SERVERBOUND) {
                ServerLevel level = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
                if (level.m_46472_() == TRDDimensions.TARDIS) {
                    String cmd = msg.command;
                    if (CommandManager.doesCommandExist(cmd)) {
                        ICommand c = CommandManager.getCommand(cmd);
                        if (c != null) {
                            String[] commandPre = cmd.split(" ");
                            String[] commandArgs = new String[commandPre.length - 1];
                            for (int i = 1; i <= commandArgs.length; ++i) {
                                commandArgs[i - 1] = commandPre[i];
                            }
                            if (c.allowedSource() == CommandTardimBase.CommandSource.BOTH || c.allowedSource() == CommandTardimBase.CommandSource.CMD) {
                                c.execute(commandArgs, (Player)((NetworkEvent.Context)ctx.get()).getSender(), msg.pos, CommandTardimBase.CommandSource.CMD);
                            } else {
                                CommandTardimBase.sendResponse((Player)((NetworkEvent.Context)ctx.get()).getSender(), "Invalid command", CommandTardimBase.ResponseType.FAIL, CommandTardimBase.CommandSource.CMD);
                            }
                        } else {
                            CommandTardimBase.sendResponse((Player)((NetworkEvent.Context)ctx.get()).getSender(), "Invalid command", CommandTardimBase.ResponseType.FAIL, CommandTardimBase.CommandSource.CMD);
                        }
                    }
                } else {
                    CommandTardimBase.sendResponse((Player)((NetworkEvent.Context)ctx.get()).getSender(), "Invalid TARDIM", CommandTardimBase.ResponseType.FAIL, CommandTardimBase.CommandSource.CMD);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

