/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.client.gui.GuiCommandScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketOpenEditGui {
    public BlockPos pos;
    public int slot;

    public PacketOpenEditGui(int slot, BlockPos pos) {
        this.pos = pos;
        this.slot = slot;
    }

    public static void encode(PacketOpenEditGui msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.slot);
        buf.m_130064_(msg.pos);
    }

    public static PacketOpenEditGui decode(FriendlyByteBuf buf) {
        return new PacketOpenEditGui(buf.readInt(), buf.m_130135_());
    }

    public static void handle(PacketOpenEditGui msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getNetworkManager().getDirection() == PacketFlow.CLIENTBOUND) {
                PacketOpenEditGui.runCient(msg, ctx);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void runCient(PacketOpenEditGui msg, Supplier<NetworkEvent.Context> ctx) {
        BlockEntity be = Minecraft.m_91087_().f_91073_.m_7702_(msg.pos);
        if (be != null) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiCommandScreen(msg.slot, be));
        }
    }
}

