/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.network.packets;

import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import com.swdteam.tileentity.TileEntityBaseTardimPanel;
import com.swdteam.tileentity.TileEntityTardimPanelButtons;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketSaveCommand {
    public BlockPos pos;
    public String command;
    public int slot;

    public PacketSaveCommand(int slot, String command, BlockPos pos) {
        this.pos = pos;
        this.command = command;
        this.slot = slot;
    }

    public static void encode(PacketSaveCommand msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.slot);
        buf.m_130070_(msg.command);
        buf.m_130064_(msg.pos);
    }

    public static PacketSaveCommand decode(FriendlyByteBuf buf) {
        return new PacketSaveCommand(buf.readInt(), buf.m_130277_(), buf.m_130135_());
    }

    public static void handle(PacketSaveCommand msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getNetworkManager().getDirection() == PacketFlow.SERVERBOUND) {
                ServerLevel level = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
                TardimData data = TardimManager.getFromPos(msg.pos);
                if (data != null && data.hasPermission((Player)((NetworkEvent.Context)ctx.get()).getSender())) {
                    BlockEntity be = level.m_7702_(msg.pos);
                    if (be instanceof TileEntityBaseTardimPanel) {
                        if (msg.slot == 1) {
                            ((TileEntityBaseTardimPanel)be).setCommand(msg.command);
                            level.m_7260_(msg.pos, level.m_8055_(msg.pos), level.m_8055_(msg.pos), 3);
                            be.m_6596_();
                        }
                        if (be instanceof TileEntityTardimPanelButtons) {
                            if (msg.slot == 0) {
                                ((TileEntityTardimPanelButtons)be).setCommand_l(msg.command);
                                be.m_6596_();
                                level.m_7260_(msg.pos, level.m_8055_(msg.pos), level.m_8055_(msg.pos), 3);
                            }
                            if (msg.slot == 2) {
                                ((TileEntityTardimPanelButtons)be).setCommand_r(msg.command);
                                be.m_6596_();
                                level.m_7260_(msg.pos, level.m_8055_(msg.pos), level.m_8055_(msg.pos), 3);
                            }
                        }
                    }
                } else {
                    ((NetworkEvent.Context)ctx.get()).getSender().m_5661_((Component)new TextComponent("You do not have permission").m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

