/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim;

import com.mojang.math.Vector3d;
import com.swdteam.main.Tardim;
import com.swdteam.tardim.TardimSaveHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TardimData {
    private int id;
    private UUID owner;
    private String owner_name;
    private Vector3d door_position;
    private float door_rotation;
    private Location current_location;
    private Location travel_location;
    private long entered_flight;
    private boolean in_flight;
    private boolean locked;
    private double fuel = 100.0;
    private List<Companion> companions = new ArrayList<Companion>();

    public TardimData(int id) {
        this.id = id;
    }

    public List<Companion> getCompanions() {
        if (this.companions == null) {
            this.companions = new ArrayList<Companion>();
        }
        return this.companions;
    }

    public void addCompanion(Player player) {
        if (this.getCompanionID(player) == -1) {
            this.getCompanions().add(new Companion(player));
            this.save();
        }
    }

    public void removeCompanion(Player player) {
        int id = this.getCompanionID(player);
        if (id != -1) {
            this.getCompanions().remove(id);
            this.save();
        }
    }

    public int getCompanionID(Player player) {
        for (int i = 0; i < this.getCompanions().size(); ++i) {
            Companion c = this.getCompanions().get(i);
            if (!c.getUuid().equals(player.m_36316_().getId())) continue;
            return i;
        }
        return -1;
    }

    public int getId() {
        return this.id;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Vector3d getDoorPosition() {
        return this.door_position;
    }

    public Location getCurrentLocation() {
        return this.current_location;
    }

    public Location getTravelLocation() {
        return this.travel_location;
    }

    public void setCurrentLocation(Location current_location) {
        this.current_location = current_location;
    }

    public void setDoorPosition(Vector3d door_position) {
        this.door_position = door_position;
    }

    public void setInFlight(boolean in_flight) {
        this.in_flight = in_flight;
    }

    public void setOwner(Player player) {
        this.owner_name = player.m_36316_().getName();
        this.owner = player.m_36316_().getId();
    }

    public void setTravelLocation(Location travel_location) {
        this.travel_location = travel_location;
    }

    public boolean isInFlight() {
        return this.in_flight;
    }

    public String getOwnerName() {
        return this.owner_name;
    }

    public long getTimeEnteredFlight() {
        return this.entered_flight;
    }

    public void setTimeEnteredFlight(long entered_flight) {
        this.entered_flight = entered_flight;
    }

    public void setTimeEnteredFlight() {
        this.entered_flight = System.currentTimeMillis() / 1000L;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean hasPermission(Player player) {
        return this.getOwner().equals(player.m_36316_().getId()) || this.getCompanionID(player) != -1;
    }

    public boolean isOwner(Player player) {
        return this.getOwner().equals(player.m_36316_().getId());
    }

    public void save() {
        TardimSaveHandler.saveTardisData(this);
    }

    public float getDoorRotation() {
        return this.door_rotation;
    }

    public void setDoorRotation(float door_rotation) {
        this.door_rotation = door_rotation;
    }

    public double getFuel() {
        return this.fuel;
    }

    public void setFuel(double fuel) {
        this.fuel = fuel;
    }

    public void addFuel(double amount) {
        this.fuel = this.fuel + amount > 100.0 ? 100.0 : (this.fuel + amount < 0.0 ? 0.0 : (this.fuel += amount));
    }

    public double calculateFuelForJourney(Level level, Level destLevel, BlockPos pos, BlockPos destPos) {
        Vec3 posB;
        Vec3 posA;
        double distance;
        double fuel = 0.0;
        if (level != destLevel) {
            fuel = 10.0;
        }
        if ((fuel += (distance = (posA = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_82554_(posB = new Vec3((double)destPos.m_123341_(), (double)destPos.m_123342_(), (double)destPos.m_123343_())) / 100.0)) > 100.0) {
            fuel = 100.0;
        }
        return fuel;
    }

    public static class Companion {
        private String username;
        private UUID uuid;

        public Companion(Player player) {
            this.username = player.m_36316_().getName();
            this.uuid = player.m_36316_().getId();
        }

        public String getUsername() {
            return this.username;
        }

        public UUID getUuid() {
            return this.uuid;
        }
    }

    public static class Location {
        private Vector3d pos;
        private String level_loc;
        private Direction direction;
        private transient ResourceKey level;
        private transient BlockPos position;

        public Location(BlockPos pos, ResourceKey<Level> level) {
            this.pos = new Vector3d((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            this.level_loc = level.m_135782_().toString();
            this.level = level;
            this.position = pos;
            this.direction = Tardim.RANDOM.nextBoolean() ? Direction.NORTH : (Tardim.RANDOM.nextBoolean() ? Direction.SOUTH : (Tardim.RANDOM.nextBoolean() ? Direction.WEST : Direction.EAST));
        }

        public Location(Location l) {
            this.pos = new Vector3d((double)l.getPos().m_123341_(), (double)l.getPos().m_123342_(), (double)l.getPos().m_123343_());
            this.level_loc = l.level_loc;
            this.level = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.level_loc));
            this.position = new BlockPos(l.getPos().m_123341_(), l.getPos().m_123342_(), l.getPos().m_123343_());
            this.direction = Tardim.RANDOM.nextBoolean() ? Direction.NORTH : (Tardim.RANDOM.nextBoolean() ? Direction.SOUTH : (Tardim.RANDOM.nextBoolean() ? Direction.WEST : Direction.EAST));
        }

        public ResourceKey getLevel() {
            if (this.level == null) {
                this.level = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.level_loc));
            }
            return this.level;
        }

        public BlockPos getPos() {
            if (this.position == null) {
                this.position = new BlockPos(this.pos.f_86214_, this.pos.f_86215_, this.pos.f_86216_);
            }
            return this.position;
        }

        public Location setPosition(int x, int y, int z) {
            this.pos = new Vector3d((double)x, (double)y, (double)z);
            this.position = new BlockPos(x, y, z);
            return this;
        }

        public Location addPosition(int x, int y, int z) {
            this.position = this.position.m_142082_(x, y, z);
            this.pos = new Vector3d((double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_());
            return this;
        }

        public Location setLocation(ResourceKey<Level> level) {
            this.level_loc = level.m_135782_().toString();
            this.level = level;
            return this;
        }

        public Location setFacing(Direction d) {
            this.direction = d;
            return this;
        }

        public Direction getFacing() {
            if (this.direction == null) {
                this.direction = Direction.NORTH;
            }
            return this.direction;
        }
    }
}

