/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim;

import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimSaveHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;

public class TardimManager {
    public static int INTERIOR_BOUNDS = 96;
    public static Map<String, String> DIMENSION_MAP = new HashMap<String, String>();
    public static Map<Item, Double> FUEL_MAP = new HashMap<Item, Double>();
    private static Map<Integer, TardimData> TARDIM_DATA = new HashMap<Integer, TardimData>();

    public static TardimData getTardim(int i) {
        if (!TARDIM_DATA.containsKey(i)) {
            TardimSaveHandler.loadTardisData(i);
        }
        return TARDIM_DATA.get(i);
    }

    public static boolean isFuel(Item i) {
        return FUEL_MAP.containsKey(i);
    }

    public static double getFuel(Item i) {
        return TardimManager.isFuel(i) ? FUEL_MAP.get(i) : 0.0;
    }

    public static Map<Item, Double> getFuelMap() {
        return FUEL_MAP;
    }

    public static Map<Integer, TardimData> getCache() {
        return TARDIM_DATA;
    }

    public static BlockPos getXZForMap(int np) {
        int dx = 0;
        int dy = 1;
        int segment_length = 1;
        int x = 0;
        int y = 0;
        int segment_passed = 0;
        if (np == 0) {
            return new BlockPos(x, 0, y);
        }
        for (int n = 0; n < np; ++n) {
            x += dx;
            y += dy;
            if (++segment_passed != segment_length) continue;
            segment_passed = 0;
            int buffer = dy;
            dy = -dx;
            dx = buffer;
            if (dx != 0) continue;
            ++segment_length;
        }
        return new BlockPos(x, 0, y);
    }

    public static TardimData getFromPos(BlockPos pos) {
        return TardimManager.getTardim(TardimManager.getIDForXZ(pos.m_123341_(), pos.m_123343_()));
    }

    public static int getIDForXZ(int X, int Z) {
        int index = 0;
        int x = 0;
        int y = 0;
        int dx = 0;
        int dy = 1;
        int segment_length = 1;
        int segment_passed = 0;
        int fX = X;
        int fZ = Z;
        boolean found = false;
        long timecheck = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - timecheck > 10000L) {
                System.out.println("Finding ID from XZ Coordinates is taking too long!");
                break;
            }
            if (fX >= x * INTERIOR_BOUNDS && fX <= INTERIOR_BOUNDS + x * INTERIOR_BOUNDS && fZ >= y * INTERIOR_BOUNDS && fZ <= INTERIOR_BOUNDS + y * INTERIOR_BOUNDS) {
                found = true;
                break;
            }
            x += dx;
            y += dy;
            if (++segment_passed == segment_length) {
                segment_passed = 0;
                int buffer = dy;
                dy = -dx;
                dx = buffer;
                if (dx == 0) {
                    ++segment_length;
                }
            }
            ++index;
        }
        if (!found) {
            index = 0;
        }
        return index;
    }
}

