/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim;

import com.swdteam.main.Config;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimIDMap;
import com.swdteam.tardim.TardimManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class TardimSaveHandler {
    public static MinecraftServer SERVER;

    public static void loadInteriorBounds(MinecraftServer server) throws Exception {
        File file = new File(server.m_129843_(LevelResource.f_78182_) + "/tardim/ib.dat");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            FileWriter wr = new FileWriter(file);
            wr.write("" + Config.INSTANCE.getInteriorBounds());
            wr.close();
            TardimManager.INTERIOR_BOUNDS = Config.INSTANCE.getInteriorBounds();
            System.out.println("Saving interior bounds: " + TardimManager.INTERIOR_BOUNDS);
        } else {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer sb = new StringBuffer();
            String s = reader.readLine();
            int i = Integer.parseInt(s);
            System.out.println("Loading interior bounds: " + i);
            if (i < 64) {
                System.out.println("Interior bounds too small, defaulting to 64");
                i = 64;
            }
            TardimManager.INTERIOR_BOUNDS = i;
        }
    }

    public static void saveTardisData(TardimData data) {
        if (data != null) {
            File file = new File(SERVER.m_129843_(LevelResource.f_78182_) + "/tardim/data/tardim_" + data.getId() + ".json");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                FileWriter writer = new FileWriter(file);
                writer.write(TardimIDMap.GSON.toJson((Object)data));
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void loadTardisData(int globalID) {
        if (TardimManager.getCache().containsKey(globalID)) {
            return;
        }
        File file = new File(SERVER.m_129843_(LevelResource.f_78182_) + "/tardim/data/tardim_" + globalID + ".json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuffer sb = new StringBuffer();
                String s = null;
                while ((s = reader.readLine()) != null) {
                    sb.append(s);
                }
                TardimData data = (TardimData)TardimIDMap.GSON.fromJson(sb.toString(), TardimData.class);
                reader.close();
                TardimManager.getCache().put(data.getId(), data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            TardimData data = new TardimData(globalID);
            data.save();
            TardimManager.getCache().put(data.getId(), data);
        }
    }
}

