/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tileentity;

import com.swdteam.common.block.BlockFuelStorage;
import com.swdteam.common.init.TRDDimensions;
import com.swdteam.common.init.TRDTiles;
import com.swdteam.tardim.TardimData;
import com.swdteam.tardim.TardimManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityFuelStorage
extends BlockEntity {
    private int cooldown = 0;

    public TileEntityFuelStorage(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TRDTiles.TILE_FUEL_STORAGE.get(), p_155229_, p_155230_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TileEntityFuelStorage tile) {
        TardimData data;
        if (!level.f_46443_ && level.m_46472_() == TRDDimensions.TARDIS && (data = TardimManager.getFromPos(pos)) != null) {
            int currentFuel = (Integer)state.m_61143_((Property)BlockFuelStorage.FUEL_STATE);
            double newFuel = data.getFuel();
            int stateID = tile.getStateIDForLevel(newFuel);
            if (stateID != currentFuel) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockFuelStorage.FUEL_STATE, (Comparable)Integer.valueOf(stateID)), 3);
            }
            if (level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50332_ && level.m_8055_(pos.m_7494_()).m_61143_((Property)HopperBlock.f_54021_) == Direction.DOWN) {
                ++tile.cooldown;
                if (tile.cooldown >= 10) {
                    tile.cooldown = 0;
                    if (data.getFuel() < 100.0) {
                        HopperBlockEntity hopper = (HopperBlockEntity)level.m_7702_(pos.m_7494_());
                        for (int i = 0; i < hopper.m_6643_(); ++i) {
                            ItemStack stack = hopper.m_8020_(i);
                            double fuel = TardimManager.getFuel(stack.m_41720_());
                            if (!(fuel > 0.0)) continue;
                            hopper.m_7407_(i, 1);
                            data.addFuel(fuel);
                            break;
                        }
                    }
                }
            }
        }
    }

    public int getStateIDForLevel(double fuelLevel) {
        int fuel = (int)fuelLevel;
        if (fuel >= 100) {
            return 0;
        }
        if (fuel % 10 > 0) {
            fuel += 10 - fuel % 10;
        }
        switch (fuel) {
            case 100: {
                return 0;
            }
            case 90: {
                return 1;
            }
            case 80: {
                return 2;
            }
            case 70: {
                return 3;
            }
            case 60: {
                return 4;
            }
            case 50: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 30: {
                return 7;
            }
            case 20: {
                return 8;
            }
            case 10: {
                return 9;
            }
        }
        return 9;
    }
}

