/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.util.world;

import com.google.common.collect.ImmutableMap;
import com.swdteam.util.world.TileData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class Schematic
implements Serializable {
    public int schem_dim_x;
    public int schem_dim_y;
    public int schem_dim_z;
    public Map<Integer, String> blockTable = new HashMap<Integer, String>();
    public int[] blockMap;
    public List<TileData> tileData = new ArrayList<TileData>();

    public Schematic(int x, int y, int z) {
        this.schem_dim_x = x;
        this.schem_dim_y = y;
        this.schem_dim_z = z;
    }

    public int getBlockID(BlockState tag) {
        Object block = Registry.f_122824_.m_7981_((Object)tag.m_60734_()).toString();
        ImmutableMap immutablemap = tag.m_61148_();
        if (!immutablemap.isEmpty()) {
            for (Map.Entry entry : immutablemap.entrySet()) {
                Property Property2 = (Property)entry.getKey();
                block = (String)block + "," + Property2.m_61708_() + "=" + this.getName(Property2, (Comparable)entry.getValue());
            }
        }
        if (!this.blockTable.containsValue(block)) {
            int id = this.blockTable.size();
            this.blockTable.put(id, (String)block);
        }
        int id = this.getKeyByValue(this.blockTable, block);
        return id;
    }

    public <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public BlockState getStateFromID(int id) {
        String s = this.blockTable.get(id);
        if (s == null) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState state = this.readBlockState(s);
        if (state == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    private BlockState readBlockState(String string) {
        String[] data = string.split(",");
        Block block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(data[0]));
        BlockState blockstate = block.m_49966_();
        StateDefinition stateDefinition = block.m_49965_();
        for (int i = 1; i < data.length; ++i) {
            String[] s = data[i].split("=");
            String key = s[0];
            String value = s[1];
            Property Property2 = stateDefinition.m_61081_(key);
            if (Property2 == null) continue;
            blockstate = Schematic.setValueHelper(blockstate, Property2, value);
        }
        return blockstate;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S p_193590_0_, Property<T> p_193590_1_, String blockState) {
        Optional optional = p_193590_1_.m_6215_(blockState);
        if (optional.isPresent()) {
            return (S)((StateHolder)p_193590_0_.m_61124_(p_193590_1_, (Comparable)optional.get()));
        }
        return p_193590_0_;
    }

    private <T extends Comparable<T>> String getName(Property<T> p_190010_0_, Comparable<?> p_190010_1_) {
        return p_190010_0_.m_6940_(p_190010_1_);
    }

    public int getSchemDimX() {
        return this.schem_dim_x;
    }

    public int getSchemDimY() {
        return this.schem_dim_y;
    }

    public int getSchemDimZ() {
        return this.schem_dim_z;
    }

    public List<TileData> getTileData() {
        return this.tileData;
    }

    public void setTileData(List<TileData> tileData) {
        this.tileData = tileData;
    }

    public void setBlockMap(int[] blockMap) {
        this.blockMap = blockMap;
    }
}

