/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.util.world;

import com.swdteam.util.world.Schematic;
import com.swdteam.util.world.TileData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SchematicUtils {
    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Schematic loadSchematic(String file, FileLocation location) {
        Schematic schem = null;
        if (location == FileLocation.INTERNAL) {
            InputStream stream = SchematicUtils.class.getResourceAsStream("/assets/tardim/interior/" + file + ".schm");
            try {
                ObjectInputStream ois = new ObjectInputStream(stream);
                Object o = ois.readObject();
                ois.close();
                if (!(o instanceof Schematic)) return schem;
                schem = (Schematic)o;
                return schem;
            }
            catch (Exception e) {
                e.printStackTrace();
                return schem;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (location != FileLocation.EXTERNAL) return schem;
        try {
            FileInputStream stream = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(stream);
            Object o = ois.readObject();
            if (o instanceof Schematic) {
                schem = (Schematic)o;
            }
            ois.close();
            return schem;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schem;
    }

    public static void saveSchematic(Schematic schem, String fileName) {
        String fileDir = "mods/TARDIM/Schematics/";
        fileName = (String)fileName + ".schm";
        try {
            File file = new File(fileDir + (String)fileName);
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file, false);
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(schem);
            stream.close();
            System.out.println(file.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateSchematic(GenerationQueue queue, Level w, BlockPos p, Schematic schem) {
        if (schem != null) {
            SchematicUtils.generateSchematic(queue, w, p, schem, null, null, null);
        }
    }

    public static void generateSchematic(GenerationQueue queue, Level w, BlockPos p, Schematic schem, BlockState[] blocksToIgnore, BlockState airBlock) {
        SchematicUtils.generateSchematic(queue, w, p, schem, blocksToIgnore, airBlock, null);
    }

    public static void generateSchematic(GenerationQueue queue, Level w, BlockPos p, Schematic schem, BlockState[] blocksToIgnore, BlockState airBlock, IReplaceBlockSpawn[] blockReplace) {
        int i;
        if (schem == null) {
            return;
        }
        int chunkSize = schem.getSchemDimX() * schem.getSchemDimY() * schem.getSchemDimZ();
        int index = 0;
        ArrayList ents = new ArrayList();
        SchematicChunk chunk = new SchematicChunk(w);
        for (i = 0; i <= schem.getSchemDimY(); ++i) {
            int y = i;
            for (int x = 0; x <= schem.getSchemDimX(); ++x) {
                for (int z = 0; z <= schem.getSchemDimZ(); ++z) {
                    if (index != 0 && index % queue.chunkSize == 0) {
                        queue.getList().add(chunk);
                        chunk = new SchematicChunk(w);
                    }
                    BlockPos pos = new BlockPos(x, y, z).m_142082_(p.m_123341_(), p.m_123342_(), p.m_123343_());
                    BlockState block = schem.getStateFromID(schem.blockMap[index]);
                    chunk.blocks.add(new SchematicChunk.SchematicChunkBlockState(pos, block));
                    ++index;
                }
            }
        }
        queue.getList().add(chunk);
        chunk = new SchematicChunk(w);
        for (i = 0; i < schem.getTileData().size(); ++i) {
            TileData tileData = schem.getTileData().get(i);
            BlockPos pos = new BlockPos(p.m_123341_() + tileData.getPos()[0], p.m_123342_() + tileData.getPos()[1], p.m_123343_() + tileData.getPos()[2]);
            chunk.blocks.add(new SchematicChunk.SchematicChunkBlockState(pos, tileData.getNbtDataString()));
        }
        queue.getList().add(chunk);
        SchematicChunk cc = new SchematicChunk(w);
        cc.blocks.addAll(ents);
        queue.getList().add(cc);
    }

    public static enum FileLocation {
        INTERNAL,
        EXTERNAL;

    }

    public static enum GenerationQueue {
        DEFAULT,
        TARDIS,
        CITADEL(4096);

        private List<SchematicChunk> list = new ArrayList<SchematicChunk>();
        private int chunkSize = 512;

        private GenerationQueue() {
        }

        private GenerationQueue(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        public List<SchematicChunk> getList() {
            return this.list;
        }
    }

    public static interface IReplaceBlockSpawn {
        public void replaceBlock(Level var1, BlockPos var2);

        public boolean keepBlock();

        public BlockState getBlockState();

        public Block getBlock();
    }

    public static class SchematicChunk {
        private final ResourceKey worldID;
        private final List<SchematicChunkBlockState> blocks = new ArrayList<SchematicChunkBlockState>();

        public SchematicChunk(Level world) {
            this.worldID = world.m_46472_();
        }

        public List<SchematicChunkBlockState> getBlocks() {
            return this.blocks;
        }

        public ResourceKey getWorld() {
            return this.worldID;
        }

        public static class SchematicChunkBlockState {
            private final BlockPos p;
            private final BlockState block;
            private String nbt = "";
            private IReplaceBlockSpawn blockUpdater;

            public SchematicChunkBlockState(BlockPos p, BlockState state) {
                this.p = p;
                this.block = state;
            }

            public SchematicChunkBlockState(BlockPos p, String nbt) {
                this.p = p;
                this.block = null;
                this.nbt = nbt;
            }

            public IReplaceBlockSpawn getBlockUpdater() {
                return this.blockUpdater;
            }

            public void setBlockUpdater(IReplaceBlockSpawn blockUpdater) {
                this.blockUpdater = blockUpdater;
            }

            public BlockState getBlock() {
                return this.block;
            }

            public String getNbt() {
                return this.nbt;
            }

            public BlockPos getPos() {
                return this.p;
            }
        }
    }
}

