/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.block;

import com.swdteam.tardim.common.block.ITardimPart;
import com.swdteam.tardim.common.init.TRDItems;
import com.swdteam.tardim.common.init.TRDSounds;
import com.swdteam.tardim.common.item.ItemTardim;
import com.swdteam.tardim.main.Tardim;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import com.swdteam.tardim.tileentity.TileEntityTardim;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTardimDoors
extends Block
implements ITardimPart {
    public static final VoxelShape CLOSED_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape CLOSED_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_EAST = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape OPEN_NORTH = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_SOUTH = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_EAST = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_WEST = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_COL_NORTH = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_COL_SOUTH = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_COL_EAST = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_COL_WEST = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty FRONT = BooleanProperty.func_177716_a((String)"front");
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final DirectionProperty BUILT_FACING = DirectionProperty.func_177712_a((String)"built_facing", (Predicate)Direction.Plane.HORIZONTAL);

    public BlockTardimDoors(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FRONT, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return open ? OPEN_NORTH : CLOSED_NORTH;
            }
            case SOUTH: {
                return open ? OPEN_SOUTH : CLOSED_SOUTH;
            }
            case EAST: {
                return open ? OPEN_EAST : CLOSED_EAST;
            }
            case WEST: {
                return open ? OPEN_WEST : CLOSED_WEST;
            }
        }
        return super.func_220053_a(state, p_220053_2_, p_220053_3_, p_220053_4_);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return OPEN_COL_NORTH;
                }
                case SOUTH: {
                    return OPEN_COL_SOUTH;
                }
                case EAST: {
                    return OPEN_COL_EAST;
                }
                case WEST: {
                    return OPEN_COL_WEST;
                }
            }
        }
        return super.func_220071_b(state, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{HALF, FACING, OPEN, FRONT, BUILT_FACING});
    }

    public ActionResultType func_225533_a_(BlockState p_60503_, World p_60504_, BlockPos p_60505_, PlayerEntity p_60506_, Hand p_60507_, BlockRayTraceResult p_60508_) {
        if (!p_60504_.field_72995_K && p_60507_ == p_60506_.func_184600_cs()) {
            World w = p_60504_;
            boolean isFront = (Boolean)p_60503_.func_177229_b((Property)FRONT);
            DoubleBlockHalf half = (DoubleBlockHalf)p_60503_.func_177229_b(HALF);
            boolean open = (Boolean)p_60503_.func_177229_b((Property)OPEN);
            BlockPos center = Tardim.INSTANCE.getCenter(w, p_60505_);
            TileEntity be = w.func_175625_s(center);
            int keyID = -1;
            if (be != null && be instanceof TileEntityTardim) {
                keyID = ((TileEntityTardim)be).tardimID;
            }
            TardimData data = TardimManager.getTardim(keyID);
            if (Tardim.INSTANCE.isDamaged(w, p_60505_)) {
                ItemTardim.destroyTardim(w, center, (Direction)p_60503_.func_177229_b((Property)BUILT_FACING));
            }
            if (isFront) {
                if (data.hasPermission(p_60506_)) {
                    if (p_60506_.func_184586_b(p_60507_).func_77973_b() == TRDItems.TARDIM_KEY.get() && keyID != -1) {
                        ItemStack stack = p_60506_.func_184586_b(p_60507_);
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new CompoundNBT());
                        }
                        if (!stack.func_77978_p().func_74764_b("key_id")) {
                            stack.func_77978_p().func_74768_a("key_id", keyID);
                            p_60506_.func_146105_b((ITextComponent)new StringTextComponent("TARDIM bound to key").func_240699_a_(TextFormatting.DARK_GREEN).func_240699_a_(TextFormatting.BOLD), true);
                            return ActionResultType.CONSUME;
                        }
                        if (data != null && stack.func_77978_p().func_74762_e("key_id") == keyID) {
                            data.setLocked(!data.isLocked());
                            data.save();
                            w.func_184133_a(null, p_60505_, (SoundEvent)TRDSounds.TARDIM_LOCK.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                            p_60506_.func_146105_b((ITextComponent)new StringTextComponent("TARDIM has been " + (data.isLocked() ? "locked" : "unlocked")).func_240699_a_(TextFormatting.DARK_GREEN).func_240699_a_(TextFormatting.BOLD), true);
                            if (((Boolean)p_60503_.func_177229_b((Property)OPEN)).booleanValue()) {
                                w.func_175656_a(p_60505_, (BlockState)w.func_180495_p(p_60505_).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                                BlockPos pos = half == DoubleBlockHalf.LOWER ? p_60505_.func_177984_a() : p_60505_.func_177977_b();
                                w.func_175656_a(pos, (BlockState)w.func_180495_p(pos).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                                w.func_217378_a(null, open ? 1012 : 1006, p_60505_, 0);
                            }
                            return ActionResultType.CONSUME;
                        }
                        p_60506_.func_146105_b((ITextComponent)new StringTextComponent("This is not the correct key").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                        return ActionResultType.CONSUME;
                    }
                } else {
                    p_60506_.func_146105_b((ITextComponent)new StringTextComponent("You do not have permission to interact with " + data.getOwnerName() + "'s TARDIM").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                    return ActionResultType.CONSUME;
                }
                if (data != null && data.isLocked()) {
                    w.func_184133_a(null, p_60505_, (SoundEvent)TRDSounds.TARDIM_LOCKED.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    p_60506_.func_146105_b((ITextComponent)new StringTextComponent("Door is locked").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                    return ActionResultType.CONSUME;
                }
                if (data != null && data.hasPermission(p_60506_)) {
                    if (data.getOwner().equals(p_60506_.func_146103_bH().getId())) {
                        data.setOwner(p_60506_);
                        data.save();
                    }
                    w.func_175656_a(p_60505_, (BlockState)w.func_180495_p(p_60505_).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                    BlockPos pos = half == DoubleBlockHalf.LOWER ? p_60505_.func_177984_a() : p_60505_.func_177977_b();
                    w.func_175656_a(pos, (BlockState)w.func_180495_p(pos).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
                    w.func_217378_a(null, open ? 1012 : 1006, p_60505_, 0);
                } else {
                    p_60506_.func_146105_b((ITextComponent)new StringTextComponent("You do not have permission to enter " + data.getOwnerName() + "'s TARDIM").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                }
            }
        }
        return ActionResultType.CONSUME;
    }

    public PushReaction func_149656_h(BlockState p_49353_) {
        return PushReaction.BLOCK;
    }
}

