/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.block;

import com.swdteam.tardim.common.init.TRDSounds;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import com.swdteam.tardim.tileentity.TileEntityTardimInteriorDoors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTardimInteriorDoors
extends Block {
    public static final VoxelShape CLOSED_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape CLOSED_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_EAST = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape OPEN_NORTH = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_SOUTH = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_EAST = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape OPEN_WEST = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    public static final VoxelShape COLLIDER = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public BlockTardimInteriorDoors(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        boolean open = (Boolean)state.func_177229_b((Property)OPEN);
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case SOUTH: {
                return open ? OPEN_NORTH : CLOSED_NORTH;
            }
            case NORTH: {
                return open ? OPEN_SOUTH : CLOSED_SOUTH;
            }
            case WEST: {
                return open ? OPEN_EAST : CLOSED_EAST;
            }
            case EAST: {
                return open ? OPEN_WEST : CLOSED_WEST;
            }
        }
        return super.func_220053_a(state, p_220053_2_, p_220053_3_, p_220053_4_);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return VoxelShapes.func_197880_a();
        }
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            return COLLIDER;
        }
        return super.func_220071_b(state, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{HALF, FACING, OPEN});
    }

    public ActionResultType func_225533_a_(BlockState p_60503_, World p_60504_, BlockPos p_60505_, PlayerEntity p_60506_, Hand p_60507_, BlockRayTraceResult p_60508_) {
        if (!p_60504_.field_72995_K && p_60507_ == p_60506_.func_184600_cs()) {
            TardimData data = TardimManager.getFromPos(p_60505_);
            if (data != null && !data.isInFlight()) {
                World w = p_60504_;
                if (data.isLocked()) {
                    p_60506_.func_146105_b((ITextComponent)new StringTextComponent("TARDIM doors are locked").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                    w.func_184133_a(null, p_60505_, (SoundEvent)TRDSounds.TARDIM_LOCKED.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    if (((Boolean)p_60503_.func_177229_b((Property)OPEN)).booleanValue()) {
                        this.doDoorThingy(w, p_60503_, p_60505_, true);
                    }
                } else {
                    this.doDoorThingy(w, p_60503_, p_60505_, (Boolean)p_60503_.func_177229_b((Property)OPEN));
                }
            } else {
                p_60506_.func_146105_b((ITextComponent)new StringTextComponent("TARDIM is currently in flight").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                if (((Boolean)p_60503_.func_177229_b((Property)OPEN)).booleanValue()) {
                    this.doDoorThingy(p_60504_, p_60503_, p_60505_, true);
                }
            }
        }
        return ActionResultType.CONSUME;
    }

    public void doDoorThingy(World w, BlockState state, BlockPos position, boolean doorState) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.func_177229_b(HALF);
        boolean open = doorState;
        w.func_175656_a(position, (BlockState)w.func_180495_p(position).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
        BlockPos pos = half == DoubleBlockHalf.LOWER ? position.func_177984_a() : position.func_177977_b();
        w.func_175656_a(pos, (BlockState)w.func_180495_p(pos).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
        w.func_217378_a(null, open ? 1012 : 1006, position, 0);
    }

    public PushReaction func_149656_h(BlockState p_49353_) {
        return PushReaction.BLOCK;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityTardimInteriorDoors();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                worldIn.func_175655_b(pos.func_177984_a(), false);
            } else {
                worldIn.func_175655_b(pos.func_177977_b(), false);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                world.func_175655_b(pos.func_177984_a(), false);
            } else {
                world.func_175655_b(pos.func_177977_b(), false);
            }
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    protected static void preventCreativeDropFromBottomPart(World p_52904_, BlockPos p_52905_, BlockState p_52906_, PlayerEntity p_52907_) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)p_52906_.func_177229_b(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = p_52904_.func_180495_p(blockpos = p_52905_.func_177977_b())).func_203425_a(p_52906_.func_177230_c()) && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)blockstate.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
            p_52904_.func_180501_a(blockpos, blockstate1, 35);
            p_52904_.func_217378_a(p_52907_, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }
}

