/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.command.tardim;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.common.command.tardim.CommandTravel;
import com.swdteam.tardim.common.data.DimensionMapReloadListener;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandFuelCalculator
extends CommandTardimBase {
    @Override
    public void execute(String[] args, PlayerEntity player, BlockPos pos, CommandTardimBase.CommandSource source) {
        TardimData data;
        World dim = player.field_70170_p;
        if (args.length >= 4) {
            String dimension = "";
            for (int i = 3; i < args.length; ++i) {
                dimension = dimension + args[i] + (i == args.length - 1 ? "" : " ");
            }
            String key = dimension = DimensionMapReloadListener.toTitleCase(dimension);
            if (TardimManager.DIMENSION_MAP.containsKey(dimension)) {
                key = TardimManager.DIMENSION_MAP.get(dimension);
            }
            if (!CommandTravel.isValidPath(key)) {
                CommandFuelCalculator.sendResponse(player, "Invalid dimension, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
            } else {
                RegistryKey r = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)new ResourceLocation(key));
                dim = player.func_184102_h().func_71218_a(r);
            }
        }
        if (args.length >= 3) {
            data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    try {
                        int x = Integer.parseInt(args[0]);
                        int y = Integer.parseInt(args[1]);
                        int z = Integer.parseInt(args[2]);
                        ServerWorld currentLevel = player.func_184102_h().func_71218_a(data.getCurrentLocation().getLevel());
                        double fuel = data.calculateFuelForJourney((World)currentLevel, dim, data.getCurrentLocation().getPos(), new BlockPos(x, y, z));
                        fuel *= 100.0;
                        fuel = (int)fuel;
                        CommandFuelCalculator.sendResponse(player, "Estimated fuel usage: " + (fuel /= 100.0), CommandTardimBase.ResponseType.COMPLETE, source);
                    }
                    catch (Exception e) {
                        CommandFuelCalculator.sendResponse(player, "Invalid coordinates", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    CommandFuelCalculator.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            data = TardimManager.getFromPos(pos);
            if (data != null && data.hasPermission(player)) {
                if (data.getTravelLocation() != null) {
                    ServerWorld currentLevel = player.func_184102_h().func_71218_a(data.getCurrentLocation().getLevel());
                    ServerWorld nextLevel = player.func_184102_h().func_71218_a(data.getTravelLocation().getLevel());
                    double fuel = data.calculateFuelForJourney((World)currentLevel, (World)nextLevel, data.getCurrentLocation().getPos(), data.getTravelLocation().getPos());
                    fuel *= 100.0;
                    fuel = (int)fuel;
                    CommandFuelCalculator.sendResponse(player, "Estimated fuel usage: " + (fuel /= 100.0), CommandTardimBase.ResponseType.COMPLETE, source);
                } else {
                    CommandFuelCalculator.sendResponse(player, "No flight information set", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        }
    }

    @Override
    public String getCommandName() {
        return "fuel-calc";
    }

    @Override
    public String getUsage() {
        return "/fuel-calc (x, y, z) (dimension)";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

