/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.command.tardim;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class CommandLocateBiome
extends CommandTardimBase {
    @Override
    public void execute(String[] args, PlayerEntity player, BlockPos pos, CommandTardimBase.CommandSource source) {
        if (args.length == 1) {
            TardimData data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    Optional biome = player.func_184102_h().func_244267_aX().func_243612_b(Registry.field_239720_u_).func_241873_b(new ResourceLocation(args[0]));
                    if (biome != null && biome.isPresent()) {
                        if (data.getTravelLocation() == null) {
                            data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                        }
                        ServerWorld level = player.func_184102_h().func_71218_a(data.getTravelLocation().getLevel());
                        BlockPos blockpos = new BlockPos(data.getTravelLocation().getPos().func_177958_n(), level.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, data.getTravelLocation().getPos()).func_177956_o(), data.getTravelLocation().getPos().func_177952_p());
                        BlockPos blockpos1 = level.func_241116_a_((Biome)biome.get(), blockpos, 6400, 8);
                        System.out.println(level.func_234923_W_());
                        if (blockpos1 != null) {
                            data.getTravelLocation().setPosition(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
                            data.save();
                            CommandLocateBiome.sendResponse(player, "Coordinates set to: " + blockpos1.func_177958_n() + ", " + blockpos1.func_177956_o() + ", " + blockpos1.func_177952_p(), CommandTardimBase.ResponseType.COMPLETE, source);
                        } else {
                            CommandLocateBiome.sendResponse(player, "Cannot locate biome", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    } else {
                        CommandLocateBiome.sendResponse(player, "Unknown biome", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    CommandLocateBiome.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            CommandLocateBiome.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
        }
    }

    @Override
    public String getCommandName() {
        return "locate-biome";
    }

    @Override
    public String getUsage() {
        return "/locate-biome <biome>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

