/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.command.tardim;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.common.command.tardim.CommandTravel;
import com.swdteam.tardim.common.data.DimensionMapReloadListener;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class CommandSetDimension
extends CommandTardimBase {
    @Override
    public void execute(String[] args, PlayerEntity player, BlockPos pos, CommandTardimBase.CommandSource source) {
        if (args.length > 0) {
            String dimension = "";
            int i = 0;
            for (String s : args) {
                dimension = dimension + s + (i == args.length - 1 ? "" : " ");
                ++i;
            }
            dimension = DimensionMapReloadListener.toTitleCase(dimension);
            TardimData data = TardimManager.getFromPos(pos);
            if (data != null) {
                if (data.hasPermission(player)) {
                    String key = dimension;
                    if (TardimManager.DIMENSION_MAP.containsKey(dimension)) {
                        key = TardimManager.DIMENSION_MAP.get(dimension);
                    }
                    if (!CommandTravel.isValidPath(key)) {
                        CommandSetDimension.sendResponse(player, "Invalid dimension", CommandTardimBase.ResponseType.FAIL, source);
                    } else {
                        RegistryKey r = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)new ResourceLocation(key));
                        if (player.func_184102_h().func_71218_a(r) != null) {
                            if (data.getTravelLocation() == null) {
                                data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                            }
                            data.getTravelLocation().setLocation((RegistryKey<World>)r);
                            CommandSetDimension.sendResponse(player, "Set dimension to: " + dimension, CommandTardimBase.ResponseType.COMPLETE, source);
                        } else {
                            CommandSetDimension.sendResponse(player, "Invalid dimension", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    }
                } else {
                    CommandSetDimension.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                }
            }
        } else {
            CommandSetDimension.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
        }
    }

    @Override
    public String getCommandName() {
        return "set-dimension";
    }

    @Override
    public String getUsage() {
        return "/set-dimension <dimension>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

