/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.command.tardim;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class CommandSetDoor
extends CommandTardimBase {
    @Override
    public void execute(String[] args, PlayerEntity player, BlockPos pos, CommandTardimBase.CommandSource source) {
        block8: {
            if (args.length == 4) {
                TardimData data = TardimManager.getFromPos(pos);
                if (data != null) {
                    if (data.hasPermission(player)) {
                        try {
                            int x = Integer.parseInt(args[0]);
                            int y = Integer.parseInt(args[1]);
                            int z = Integer.parseInt(args[2]);
                            float rotation = Float.parseFloat(args[3]);
                            if (TardimManager.getIDForXZ(x, z) == data.getId()) {
                                data.setDoorPosition(new Vector3d((double)x, (double)y, (double)z));
                                data.setDoorRotation(rotation);
                                data.save();
                                CommandSetDoor.sendResponse(player, "Position updated to: " + x + ", " + y + ", " + z + " | " + rotation, CommandTardimBase.ResponseType.COMPLETE, source);
                                break block8;
                            }
                            CommandSetDoor.sendResponse(player, "Coordinate outside interior bounds", CommandTardimBase.ResponseType.FAIL, source);
                        }
                        catch (Exception e) {
                            CommandSetDoor.sendResponse(player, "Invalid coordinate", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    } else {
                        CommandSetDoor.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
                    }
                }
            } else {
                CommandSetDoor.sendResponse(player, this.getUsage(), CommandTardimBase.ResponseType.FAIL, source);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "set-door";
    }

    @Override
    public String getUsage() {
        return "/set-door <x> <y> <z> <rotation>";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

