/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.command.tardim;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class CommandToggleFacing
extends CommandTardimBase {
    @Override
    public void execute(String[] args, PlayerEntity player, BlockPos pos, CommandTardimBase.CommandSource source) {
        TardimData data = TardimManager.getFromPos(pos);
        if (data != null) {
            if (data.hasPermission(player)) {
                if (data.getTravelLocation() == null) {
                    data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                }
                if (data.getTravelLocation().getFacing() == null) {
                    data.getTravelLocation().setFacing(Direction.NORTH);
                }
                switch (data.getTravelLocation().getFacing()) {
                    case NORTH: {
                        data.getTravelLocation().setFacing(Direction.EAST);
                        break;
                    }
                    case EAST: {
                        data.getTravelLocation().setFacing(Direction.SOUTH);
                        break;
                    }
                    case SOUTH: {
                        data.getTravelLocation().setFacing(Direction.WEST);
                        break;
                    }
                    case WEST: {
                        data.getTravelLocation().setFacing(Direction.NORTH);
                        break;
                    }
                    default: {
                        data.getTravelLocation().setFacing(Direction.NORTH);
                    }
                }
                data.save();
                CommandToggleFacing.sendResponse(player, "Landing direction set to: " + data.getTravelLocation().getFacing().toString(), CommandTardimBase.ResponseType.COMPLETE, source);
            } else {
                CommandToggleFacing.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "toggle-facing";
    }

    @Override
    public String getUsage() {
        return "/toggle-facing";
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }
}

