/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.command.tardim;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.common.data.DimensionMapReloadListener;
import com.swdteam.tardim.common.init.TRDSounds;
import com.swdteam.tardim.common.item.ItemTardim;
import com.swdteam.tardim.main.Config;
import com.swdteam.tardim.main.Tardim;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandTravel
extends CommandTardimBase {
    @Override
    public void execute(String[] args, PlayerEntity player, BlockPos pos, CommandTardimBase.CommandSource source) {
        TardimData data = TardimManager.getFromPos(pos);
        if (data != null) {
            if (data.hasPermission(player)) {
                if (args.length >= 3) {
                    try {
                        int x = Integer.parseInt(args[0]);
                        int y = Integer.parseInt(args[1]);
                        int z = Integer.parseInt(args[2]);
                        if (data.getTravelLocation() == null) {
                            data.setTravelLocation(new TardimData.Location(data.getCurrentLocation()));
                        }
                        data.getTravelLocation().setPosition(x, y, z);
                    }
                    catch (Exception e) {
                        CommandTravel.sendResponse(player, "Invalid coordinates, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                    }
                }
                if (args.length >= 4) {
                    String dimension = "";
                    for (int i = 3; i < args.length; ++i) {
                        dimension = dimension + args[i] + (i == args.length - 1 ? "" : " ");
                    }
                    String key = dimension = DimensionMapReloadListener.toTitleCase(dimension);
                    if (TardimManager.DIMENSION_MAP.containsKey(dimension)) {
                        key = TardimManager.DIMENSION_MAP.get(dimension);
                    }
                    if (!CommandTravel.isValidPath(key)) {
                        CommandTravel.sendResponse(player, "Invalid dimension, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                    } else {
                        RegistryKey r = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)new ResourceLocation(key));
                        if (player.func_184102_h().func_71218_a(r) != null) {
                            if (data.getTravelLocation() == null) {
                                data.setTravelLocation(new TardimData.Location(data.getCurrentLocation().getPos(), (RegistryKey<World>)r));
                            } else {
                                data.setTravelLocation(data.getTravelLocation().setLocation((RegistryKey<World>)r));
                            }
                        } else {
                            CommandTravel.sendResponse(player, "Invalid dimension, defaulting to current", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    }
                }
                if (data.isInFlight()) {
                    if (data.getTimeEnteredFlight() < System.currentTimeMillis() / 1000L - 10L) {
                        TardimData.Location loc = data.getTravelLocation();
                        ServerWorld level = player.func_184102_h().func_71218_a(loc.getLevel());
                        level.func_217349_x(loc.getPos());
                        BlockPos landingPosButBetter = CommandTravel.getLandingPosition((World)level, loc.getPos());
                        boolean recalc = false;
                        double fuel = data.calculateFuelForJourney((World)player.func_184102_h().func_71218_a(data.getCurrentLocation().getLevel()), (World)level, data.getCurrentLocation().getPos(), loc.getPos());
                        if (data.getFuel() >= fuel) {
                            BlockPos pos2;
                            int jj;
                            for (jj = 0; jj < 32; ++jj) {
                                if (Block.func_220064_c((IBlockReader)level, (BlockPos)landingPosButBetter.func_177977_b()) || !Block.func_220064_c((IBlockReader)level, (BlockPos)(landingPosButBetter = CommandTravel.getLandingPosition((World)level, pos2 = landingPosButBetter.func_177982_a(level.field_73012_v.nextInt(10) * (level.field_73012_v.nextBoolean() ? 1 : -1), 0, level.field_73012_v.nextInt(10) * (level.field_73012_v.nextBoolean() ? 1 : -1)))).func_177977_b())) continue;
                                recalc = true;
                                break;
                            }
                            if (!recalc) {
                                for (jj = 0; jj < 32; ++jj) {
                                    if (Block.func_220064_c((IBlockReader)level, (BlockPos)landingPosButBetter.func_177977_b()) || !Block.func_220064_c((IBlockReader)level, (BlockPos)(landingPosButBetter = CommandTravel.getLandingPosition((World)level, pos2 = landingPosButBetter.func_177982_a(level.field_73012_v.nextInt(30) * (level.field_73012_v.nextBoolean() ? 1 : -1), 0, level.field_73012_v.nextInt(30) * (level.field_73012_v.nextBoolean() ? 1 : -1)))).func_177977_b())) continue;
                                    recalc = true;
                                    break;
                                }
                            }
                            if (!recalc) {
                                for (jj = 0; jj < 32; ++jj) {
                                    if (Block.func_220064_c((IBlockReader)level, (BlockPos)landingPosButBetter.func_177977_b()) || !Block.func_220064_c((IBlockReader)level, (BlockPos)(landingPosButBetter = CommandTravel.getLandingPosition((World)level, pos2 = landingPosButBetter.func_177982_a(level.field_73012_v.nextInt(30) * (level.field_73012_v.nextBoolean() ? 1 : -1), 0, level.field_73012_v.nextInt(30) * (level.field_73012_v.nextBoolean() ? 1 : -1)))).func_177977_b())) continue;
                                    recalc = true;
                                    break;
                                }
                            }
                            if (Block.func_220064_c((IBlockReader)level, (BlockPos)landingPosButBetter.func_177977_b())) {
                                loc.setPosition(landingPosButBetter.func_177958_n(), landingPosButBetter.func_177956_o(), landingPosButBetter.func_177952_p());
                                if (Tardim.isPosValid((World)level, loc.getPos())) {
                                    ItemTardim.buildTardim((World)level, loc.getPos(), data.getTravelLocation().getFacing(), data.getId());
                                    data.setCurrentLocation(data.getTravelLocation());
                                    data.setTravelLocation(null);
                                    data.setInFlight(false);
                                    data.addFuel(-fuel);
                                    data.save();
                                    if (!recalc) {
                                        CommandTravel.sendResponse(player, "TARDIM is landing", CommandTardimBase.ResponseType.COMPLETE, source);
                                    } else {
                                        CommandTravel.sendResponse(player, "Landing recalculated due to obstruction", CommandTardimBase.ResponseType.INFO, source);
                                        CommandTravel.sendResponse(player, "TARDIM is landing", CommandTardimBase.ResponseType.COMPLETE, source);
                                    }
                                    player.field_70170_p.func_184133_a(null, pos, (SoundEvent)TRDSounds.TARDIM_LANDING.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
                                } else {
                                    CommandTravel.sendResponse(player, "TARDIM landing obstructed. Aborting...", CommandTardimBase.ResponseType.FAIL, source);
                                }
                            } else {
                                CommandTravel.sendResponse(player, "TARDIM landing obstructed. Aborting...", CommandTardimBase.ResponseType.FAIL, source);
                            }
                        } else {
                            CommandTravel.sendResponse(player, "Not enough fuel for journey", CommandTardimBase.ResponseType.FAIL, source);
                        }
                    } else {
                        CommandTravel.sendResponse(player, "TARDIM is still taking off", CommandTardimBase.ResponseType.FAIL, source);
                    }
                } else {
                    TardimData.Location loc = data.getCurrentLocation();
                    ServerWorld level = player.func_184102_h().func_71218_a(loc.getLevel());
                    ItemTardim.destroyTardim((World)level, loc.getPos(), Direction.NORTH);
                    data.setInFlight(true);
                    if (data.getTravelLocation() == null) {
                        data.setTravelLocation(data.getCurrentLocation());
                    }
                    data.setTimeEnteredFlight();
                    data.save();
                    CommandTravel.sendResponse(player, "TARDIM is taking off", CommandTardimBase.ResponseType.COMPLETE, source);
                    player.field_70170_p.func_184133_a(null, pos, (SoundEvent)TRDSounds.TARDIM_TAKEOFF.get(), SoundCategory.AMBIENT, 1.0f, 1.0f);
                }
            } else {
                CommandTravel.sendResponse(player, "You do not have permission", CommandTardimBase.ResponseType.FAIL, source);
            }
        }
    }

    @Override
    public String getCommandName() {
        return "travel";
    }

    @Override
    public String getUsage() {
        return "/travel (x, y, z) (dimension)";
    }

    public static BlockPos getLandingPosition(World worldIn, BlockPos pos) {
        BlockPos topPos;
        int y = pos.func_177956_o();
        BlockPos downPos = null;
        BlockPos upPos = null;
        for (int i = 1; i < y; ++i) {
            BlockPos pos2 = pos.func_177982_a(0, -i, 0);
            if (!CommandTravel.canLandOnBlock(worldIn, pos2)) continue;
            downPos = new BlockPos(pos2.func_177958_n(), pos2.func_177956_o(), pos.func_177952_p());
            break;
        }
        int worldHeight = worldIn.func_217301_I() - 3;
        if (Config.INSTANCE.shouldUseNetherHeight()) {
            worldHeight = 125;
        }
        for (int i = 1; i < worldHeight - y; ++i) {
            BlockPos pos2 = pos.func_177982_a(0, i, 0);
            if (!CommandTravel.canLandOnBlock(worldIn, pos2)) continue;
            upPos = new BlockPos(pos2.func_177958_n(), pos2.func_177956_o(), pos.func_177952_p());
            break;
        }
        if (upPos == null && CommandTravel.canLandOnBlock(worldIn, topPos = new BlockPos(pos.func_177958_n(), worldHeight, pos.func_177952_p()))) {
            upPos = new BlockPos(topPos.func_177958_n(), topPos.func_177956_o(), topPos.func_177952_p());
        }
        BlockPos use = pos;
        if (downPos == null && upPos != null) {
            use = upPos;
        }
        if (downPos != null && upPos == null) {
            use = downPos;
        }
        if (downPos != null && upPos != null) {
            double distanceUp = pos.func_177951_i(upPos);
            double distanceDown = pos.func_177951_i((Vector3i)downPos);
            use = distanceDown <= distanceUp ? downPos : upPos;
        }
        return new BlockPos(use.func_177958_n(), use.func_177956_o() + 1, use.func_177952_p());
    }

    public static boolean canLandOnBlock(World world, BlockPos pos) {
        return Block.func_220064_c((IBlockReader)world, (BlockPos)pos) && Tardim.isPosValid(world, pos.func_177984_a());
    }

    @Override
    public CommandTardimBase.CommandSource allowedSource() {
        return CommandTardimBase.CommandSource.BOTH;
    }

    public static boolean isValidPath(String p_135842_) {
        return ResourceLocation.func_217855_b((String)p_135842_);
    }
}

