/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.swdteam.tardim.main.Tardim;
import com.swdteam.tardim.tardim.TardimManager;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class DimensionMapReloadListener
extends JsonReloadListener {
    public DimensionMapReloadListener(Gson p_10768_, String p_10769_) {
        super(p_10768_, p_10769_);
    }

    protected void apply(Map<ResourceLocation, JsonElement> p_212853_1_, IResourceManager p_212853_2_, IProfiler p_212853_3_) {
        TardimManager.DIMENSION_MAP.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : p_212853_1_.entrySet()) {
            DimensionMap dimMap = (DimensionMap)Tardim.GSON.fromJson(entry.getValue(), DimensionMap.class);
            if (dimMap == null || dimMap.getDimensionKey() == null || dimMap.getDimensionTranslations() == null) continue;
            for (String s : dimMap.getDimensionTranslations()) {
                TardimManager.DIMENSION_MAP.put(DimensionMapReloadListener.toTitleCase(s), dimMap.dimension_key);
            }
        }
    }

    public static String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder(input.length());
        boolean nextTitleCase = true;
        for (char c : input.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                nextTitleCase = true;
            } else if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }

    public static class DimensionMap {
        private String dimension_key;
        private String[] dimension_translations;

        public String getDimensionKey() {
            return this.dimension_key;
        }

        public String[] getDimensionTranslations() {
            return this.dimension_translations;
        }
    }
}

