/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.common.init;

import com.swdteam.tardim.common.command.tardim.CommandAddCompanion;
import com.swdteam.tardim.common.command.tardim.CommandAddCoord;
import com.swdteam.tardim.common.command.tardim.CommandDemat;
import com.swdteam.tardim.common.command.tardim.CommandEcho;
import com.swdteam.tardim.common.command.tardim.CommandFlightInfo;
import com.swdteam.tardim.common.command.tardim.CommandFuel;
import com.swdteam.tardim.common.command.tardim.CommandFuelCalculator;
import com.swdteam.tardim.common.command.tardim.CommandHelp;
import com.swdteam.tardim.common.command.tardim.CommandHome;
import com.swdteam.tardim.common.command.tardim.CommandLocate;
import com.swdteam.tardim.common.command.tardim.CommandLocateBiome;
import com.swdteam.tardim.common.command.tardim.CommandLockDoor;
import com.swdteam.tardim.common.command.tardim.CommandRemat;
import com.swdteam.tardim.common.command.tardim.CommandRemoveCompanion;
import com.swdteam.tardim.common.command.tardim.CommandScan;
import com.swdteam.tardim.common.command.tardim.CommandSetDimension;
import com.swdteam.tardim.common.command.tardim.CommandSetDoor;
import com.swdteam.tardim.common.command.tardim.CommandSetFacing;
import com.swdteam.tardim.common.command.tardim.CommandSetOwner;
import com.swdteam.tardim.common.command.tardim.CommandSetPosition;
import com.swdteam.tardim.common.command.tardim.CommandToggleFacing;
import com.swdteam.tardim.common.command.tardim.CommandTravel;
import com.swdteam.tardim.common.command.tardim.ICommand;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandManager {
    public static ITextComponent INVALID = new StringTextComponent("Command does not exist").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD);
    private static Map<String, ICommand> COMMANDS = new HashMap<String, ICommand>();

    public static void init() {
        COMMANDS.clear();
        CommandManager.register(new CommandEcho());
        CommandManager.register(new CommandTravel());
        CommandManager.register(new CommandAddCoord());
        CommandManager.register(new CommandToggleFacing());
        CommandManager.register(new CommandSetFacing());
        CommandManager.register(new CommandSetDoor());
        CommandManager.register(new CommandSetPosition());
        CommandManager.register(new CommandLockDoor());
        CommandManager.register(new CommandAddCompanion());
        CommandManager.register(new CommandRemoveCompanion());
        CommandManager.register(new CommandSetDimension());
        CommandManager.register(new CommandDemat());
        CommandManager.register(new CommandRemat());
        CommandManager.register(new CommandScan());
        CommandManager.register(new CommandFlightInfo());
        CommandManager.register(new CommandLocateBiome());
        CommandManager.register(new CommandSetOwner());
        CommandManager.register(new CommandHome());
        CommandManager.register(new CommandLocate());
        CommandManager.register(new CommandFuel());
        CommandManager.register(new CommandFuelCalculator());
        CommandManager.register(new CommandHelp());
    }

    private static void register(ICommand command) {
        COMMANDS.put(command.getCommandName(), command);
    }

    public static boolean doesCommandExist(String s) {
        String command = s.replaceFirst("/", "");
        String[] parts = command.split(" ");
        if (parts.length > 0) {
            return COMMANDS.containsKey(parts[0]);
        }
        return false;
    }

    public static ICommand getCommand(String s) {
        String command = s.replaceFirst("/", "");
        String[] parts = command.split(" ");
        if (parts.length > 0) {
            return COMMANDS.get(parts[0]);
        }
        return null;
    }

    public static Map<String, ICommand> getCommandMap() {
        return COMMANDS;
    }
}

