/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class Config {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Config INSTANCE;
    private int interior_bounds = 96;
    private boolean use_hardcoded_nether_height = true;

    public Config() {
        INSTANCE = this;
    }

    public int getInteriorBounds() {
        return this.interior_bounds;
    }

    public boolean shouldUseNetherHeight() {
        return this.use_hardcoded_nether_height;
    }

    public static void load() {
        File file = new File("config/tardim.json");
        if (!file.exists()) {
            Config.generate();
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String s = null;
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            reader.close();
            INSTANCE = (Config)GSON.fromJson(sb.toString(), Config.class);
        }
        catch (Exception e) {
            INSTANCE = new Config();
        }
    }

    private static void generate() {
        File file = new File("config/tardim.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        INSTANCE = new Config();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((Object)INSTANCE));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

