/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.swdteam.tardim.common.RegistryHandler;
import com.swdteam.tardim.common.block.BlockTardimDoors;
import com.swdteam.tardim.common.block.BlockTardimFloor;
import com.swdteam.tardim.common.block.BlockTardimRoof;
import com.swdteam.tardim.common.block.ITardimPart;
import com.swdteam.tardim.common.command.CommandPos1;
import com.swdteam.tardim.common.command.CommandPos2;
import com.swdteam.tardim.common.command.CommandSchemLoad;
import com.swdteam.tardim.common.command.CommandSchemPaste;
import com.swdteam.tardim.common.command.CommandSchemSave;
import com.swdteam.tardim.common.data.DimensionMapReloadListener;
import com.swdteam.tardim.common.data.FuelMapReloadListener;
import com.swdteam.tardim.common.event.BuildEventHandler;
import com.swdteam.tardim.common.init.CommandManager;
import com.swdteam.tardim.common.init.TRDDimensions;
import com.swdteam.tardim.main.Config;
import com.swdteam.tardim.main.proxy.ClientProxy;
import com.swdteam.tardim.main.proxy.ServerProxy;
import com.swdteam.tardim.network.NetworkHandler;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimIDMap;
import com.swdteam.tardim.tardim.TardimManager;
import com.swdteam.tardim.tardim.TardimSaveHandler;
import com.swdteam.tardim.util.world.Schematic;
import com.swdteam.tardim.util.world.SchematicUtils;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tardim")
public class Tardim {
    public static Random RANDOM = new Random();
    public static String VERSION = "1.1.2";
    public static Tardim INSTANCE;
    public static final Logger LOGGER;
    public static final Gson GSON;
    public static final ServerProxy PROXY;
    public static final String MODID = "tardim";
    public static Schematic TARDIM_INTERIOR;

    public Tardim() {
        INSTANCE = this;
        Config.load();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RegistryHandler.init();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::runLater);
        this.bothSideSetup(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(BuildEventHandler.class);
    }

    private void bothSideSetup(IEventBus modEventBus) {
        CommandManager.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    private void runLater(ParallelDispatchEvent event) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PROXY.doServerStuff(event);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PROXY.doClientStuff(event);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        TardimSaveHandler.SERVER = event.getServer();
        TardimManager.getCache().clear();
        try {
            TardimIDMap.load(event.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TARDIM_INTERIOR = SchematicUtils.loadSchematic("interior", SchematicUtils.FileLocation.INTERNAL);
        CommandPos1.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandPos2.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandSchemLoad.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandSchemPaste.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandSchemSave.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new DimensionMapReloadListener(GSON, "tardim_dimension_lookup"));
        event.addListener((IFutureReloadListener)new FuelMapReloadListener(GSON, "tardim_fuel"));
    }

    @SubscribeEvent
    public void onServerStarting(WorldEvent.Save event) {
        try {
            if (TardimSaveHandler.SERVER == null) {
                return;
            }
            TardimIDMap.save(TardimSaveHandler.SERVER);
            Map<Integer, TardimData> data = TardimManager.getCache();
            for (Map.Entry<Integer, TardimData> entry : data.entrySet()) {
                entry.getValue().save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_234923_W_() == TRDDimensions.TARDIS) {
            try {
                TardimSaveHandler.loadInteriorBounds(((ServerWorld)event.getWorld()).func_73046_m());
            }
            catch (Exception e) {
                e.printStackTrace();
                TardimManager.INTERIOR_BOUNDS = Config.INSTANCE.getInteriorBounds();
            }
        }
    }

    public static boolean isPosValid(World level, BlockPos pos) {
        return Tardim.validPos(level, pos) && Tardim.validPos(level, pos.func_177984_a()) && Tardim.validPos(level, pos.func_177984_a().func_177984_a()) && Tardim.validPos(level, pos.func_177978_c()) && Tardim.validPos(level, pos.func_177978_c().func_177984_a()) && Tardim.validPos(level, pos.func_177968_d()) && Tardim.validPos(level, pos.func_177968_d().func_177984_a()) && Tardim.validPos(level, pos.func_177974_f()) && Tardim.validPos(level, pos.func_177974_f().func_177984_a()) && Tardim.validPos(level, pos.func_177976_e()) && Tardim.validPos(level, pos.func_177976_e().func_177984_a());
    }

    private static boolean validPos(World l, BlockPos pos) {
        BlockState blockstate = l.func_180495_p(pos);
        if (blockstate.func_185904_a() == Material.field_151582_l || blockstate.func_185904_a() == Material.field_151585_k || blockstate.func_177230_c() == Blocks.field_150433_aE) {
            return true;
        }
        return blockstate.func_196958_f();
    }

    public BlockPos getCenter(World level, BlockPos pos) {
        BlockPos centerPos = null;
        BlockState state = level.func_180495_p(pos);
        if (state.func_177230_c() instanceof ITardimPart) {
            if (state.func_177230_c() instanceof BlockTardimDoors) {
                boolean upper = state.func_177229_b(BlockTardimDoors.HALF) == DoubleBlockHalf.UPPER;
                Direction dir = (Direction)state.func_177229_b((Property)BlockTardimDoors.FACING);
                centerPos = pos.func_177972_a(dir).func_177982_a(0, upper ? -1 : 0, 0);
            } else if (state.func_177230_c() instanceof BlockTardimRoof) {
                centerPos = pos.func_177977_b().func_177977_b();
            } else if (state.func_177230_c() instanceof BlockTardimFloor) {
                centerPos = pos;
            }
        }
        return centerPos;
    }

    public boolean isDamaged(World level, BlockPos pos) {
        BlockPos centerPos = this.getCenter(level, pos);
        if (centerPos == null) {
            return true;
        }
        boolean doorsIntact = level.func_180495_p(centerPos.func_177978_c()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177968_d()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177976_e()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177974_f()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177984_a().func_177978_c()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177984_a().func_177968_d()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177984_a().func_177976_e()).func_177230_c() instanceof BlockTardimDoors && level.func_180495_p(centerPos.func_177984_a().func_177974_f()).func_177230_c() instanceof BlockTardimDoors;
        boolean roofIntact = level.func_180495_p(centerPos.func_177984_a().func_177984_a()).func_177230_c() instanceof BlockTardimRoof;
        boolean floorIntact = level.func_180495_p(centerPos).func_177230_c() instanceof BlockTardimFloor;
        return !doorsIntact || !roofIntact || !floorIntact;
    }

    static {
        LOGGER = LogManager.getLogger();
        GSON = new GsonBuilder().setPrettyPrinting().create();
        PROXY = (ServerProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    }
}

