/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.network.packets;

import com.swdteam.tardim.common.command.tardim.CommandTardimBase;
import com.swdteam.tardim.common.command.tardim.ICommand;
import com.swdteam.tardim.common.init.CommandManager;
import com.swdteam.tardim.common.init.TRDDimensions;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketExecuteCommand {
    public BlockPos pos;
    public String command;

    public PacketExecuteCommand(String command, BlockPos pos) {
        this.pos = pos;
        this.command = command;
    }

    public static void encode(PacketExecuteCommand msg, PacketBuffer buf) {
        buf.func_180714_a(msg.command);
        buf.func_179255_a(msg.pos);
    }

    public static PacketExecuteCommand decode(PacketBuffer buf) {
        return new PacketExecuteCommand(buf.func_218666_n(), buf.func_179259_c());
    }

    public static void handle(PacketExecuteCommand msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getNetworkManager().getDirection() == PacketDirection.SERVERBOUND) {
                ServerWorld level = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
                if (level.func_234923_W_() == TRDDimensions.TARDIS) {
                    String cmd = msg.command;
                    if (CommandManager.doesCommandExist(cmd)) {
                        ICommand c = CommandManager.getCommand(cmd);
                        if (c != null) {
                            String[] commandPre = cmd.split(" ");
                            String[] commandArgs = new String[commandPre.length - 1];
                            for (int i = 1; i <= commandArgs.length; ++i) {
                                commandArgs[i - 1] = commandPre[i];
                            }
                            if (c.allowedSource() == CommandTardimBase.CommandSource.BOTH || c.allowedSource() == CommandTardimBase.CommandSource.CMD) {
                                c.execute(commandArgs, (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), msg.pos, CommandTardimBase.CommandSource.CMD);
                            } else {
                                CommandTardimBase.sendResponse((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), "Invalid command", CommandTardimBase.ResponseType.FAIL, CommandTardimBase.CommandSource.CMD);
                            }
                        } else {
                            CommandTardimBase.sendResponse((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), "Invalid command", CommandTardimBase.ResponseType.FAIL, CommandTardimBase.CommandSource.CMD);
                        }
                    }
                } else {
                    CommandTardimBase.sendResponse((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), "Invalid TARDIM", CommandTardimBase.ResponseType.FAIL, CommandTardimBase.CommandSource.CMD);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

