/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.network.packets;

import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import com.swdteam.tardim.tileentity.TileEntityBaseTardimPanel;
import com.swdteam.tardim.tileentity.TileEntityTardimPanelButtons;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSaveCommand {
    public BlockPos pos;
    public String command;
    public int slot;

    public PacketSaveCommand(int slot, String command, BlockPos pos) {
        this.pos = pos;
        this.command = command;
        this.slot = slot;
    }

    public static void encode(PacketSaveCommand msg, PacketBuffer buf) {
        buf.writeInt(msg.slot);
        buf.func_180714_a(msg.command);
        buf.func_179255_a(msg.pos);
    }

    public static PacketSaveCommand decode(PacketBuffer buf) {
        return new PacketSaveCommand(buf.readInt(), buf.func_218666_n(), buf.func_179259_c());
    }

    public static void handle(PacketSaveCommand msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getNetworkManager().getDirection() == PacketDirection.SERVERBOUND) {
                ServerWorld level = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
                TardimData data = TardimManager.getFromPos(msg.pos);
                if (data != null && data.hasPermission((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                    TileEntity be = level.func_175625_s(msg.pos);
                    if (be instanceof TileEntityBaseTardimPanel) {
                        if (msg.slot == 1) {
                            ((TileEntityBaseTardimPanel)be).setCommand(msg.command);
                            level.func_184138_a(msg.pos, level.func_180495_p(msg.pos), level.func_180495_p(msg.pos), 3);
                            be.func_70296_d();
                        }
                        if (be instanceof TileEntityTardimPanelButtons) {
                            if (msg.slot == 0) {
                                ((TileEntityTardimPanelButtons)be).setCommand_l(msg.command);
                                be.func_70296_d();
                                level.func_184138_a(msg.pos, level.func_180495_p(msg.pos), level.func_180495_p(msg.pos), 3);
                            }
                            if (msg.slot == 2) {
                                ((TileEntityTardimPanelButtons)be).setCommand_r(msg.command);
                                be.func_70296_d();
                                level.func_184138_a(msg.pos, level.func_180495_p(msg.pos), level.func_180495_p(msg.pos), 3);
                            }
                        }
                    }
                } else {
                    ((NetworkEvent.Context)ctx.get()).getSender().func_146105_b((ITextComponent)new StringTextComponent("You do not have permission").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

