/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.network.packets;

import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import com.swdteam.tardim.tileentity.TileEntityBaseTardimPanel;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSaveTooltip {
    public BlockPos pos;
    public String tooltip;
    public int slot;

    public PacketSaveTooltip(int slot, String command, BlockPos pos) {
        this.pos = pos;
        this.tooltip = command;
        this.slot = slot;
    }

    public static void encode(PacketSaveTooltip msg, PacketBuffer buf) {
        buf.writeInt(msg.slot);
        buf.func_180714_a(msg.tooltip);
        buf.func_179255_a(msg.pos);
    }

    public static PacketSaveTooltip decode(PacketBuffer buf) {
        return new PacketSaveTooltip(buf.readInt(), buf.func_218666_n(), buf.func_179259_c());
    }

    public static void handle(PacketSaveTooltip msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getNetworkManager().getDirection() == PacketDirection.SERVERBOUND) {
                ServerWorld level = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q();
                TardimData data = TardimManager.getFromPos(msg.pos);
                if (data != null && data.hasPermission((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                    TileEntity be = level.func_175625_s(msg.pos);
                    if (be instanceof TileEntityBaseTardimPanel) {
                        ((TileEntityBaseTardimPanel)be).setTooltip(msg.tooltip, msg.slot);
                        level.func_184138_a(msg.pos, level.func_180495_p(msg.pos), level.func_180495_p(msg.pos), 3);
                        be.func_70296_d();
                    }
                } else {
                    ((NetworkEvent.Context)ctx.get()).getSender().func_146105_b((ITextComponent)new StringTextComponent("You do not have permission").func_240699_a_(TextFormatting.DARK_RED).func_240699_a_(TextFormatting.BOLD), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

