/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.tardim;

import com.swdteam.tardim.main.Tardim;
import com.swdteam.tardim.tardim.TardimSaveHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class TardimData {
    private int id;
    private UUID owner;
    private String owner_name;
    private Vector3d door_position;
    private float door_rotation;
    private Location current_location;
    private Location travel_location;
    private long entered_flight;
    private boolean in_flight;
    private boolean locked;
    private double fuel = 100.0;
    private List<Companion> companions = new ArrayList<Companion>();

    public TardimData(int id) {
        this.id = id;
    }

    public List<Companion> getCompanions() {
        if (this.companions == null) {
            this.companions = new ArrayList<Companion>();
        }
        return this.companions;
    }

    public void addCompanion(PlayerEntity player) {
        if (this.getCompanionID(player) == -1) {
            this.getCompanions().add(new Companion(player));
            this.save();
        }
    }

    public void removeCompanion(PlayerEntity player) {
        int id = this.getCompanionID(player);
        if (id != -1) {
            this.getCompanions().remove(id);
            this.save();
        }
    }

    public int getCompanionID(PlayerEntity player) {
        for (int i = 0; i < this.getCompanions().size(); ++i) {
            Companion c = this.getCompanions().get(i);
            if (!c.getUuid().equals(player.func_146103_bH().getId())) continue;
            return i;
        }
        return -1;
    }

    public int getId() {
        return this.id;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Vector3d getDoorPosition() {
        return this.door_position;
    }

    public Location getCurrentLocation() {
        return this.current_location;
    }

    public Location getTravelLocation() {
        return this.travel_location;
    }

    public void setCurrentLocation(Location current_location) {
        this.current_location = current_location;
    }

    public void setDoorPosition(Vector3d door_position) {
        this.door_position = door_position;
    }

    public void setInFlight(boolean in_flight) {
        this.in_flight = in_flight;
    }

    public void setOwner(PlayerEntity player) {
        this.owner_name = player.func_146103_bH().getName();
        this.owner = player.func_146103_bH().getId();
    }

    public void setTravelLocation(Location travel_location) {
        this.travel_location = travel_location;
    }

    public boolean isInFlight() {
        return this.in_flight;
    }

    public String getOwnerName() {
        return this.owner_name;
    }

    public long getTimeEnteredFlight() {
        return this.entered_flight;
    }

    public void setTimeEnteredFlight(long entered_flight) {
        this.entered_flight = entered_flight;
    }

    public void setTimeEnteredFlight() {
        this.entered_flight = System.currentTimeMillis() / 1000L;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean hasPermission(PlayerEntity player) {
        return this.getOwner().equals(player.func_146103_bH().getId()) || this.getCompanionID(player) != -1;
    }

    public boolean isOwner(PlayerEntity player) {
        return this.getOwner().equals(player.func_146103_bH().getId());
    }

    public void save() {
        TardimSaveHandler.saveTardisData(this);
    }

    public float getDoorRotation() {
        return this.door_rotation;
    }

    public void setDoorRotation(float door_rotation) {
        this.door_rotation = door_rotation;
    }

    public double getFuel() {
        return this.fuel;
    }

    public void setFuel(double fuel) {
        this.fuel = fuel;
    }

    public void addFuel(double amount) {
        this.fuel = this.fuel + amount > 100.0 ? 100.0 : (this.fuel + amount < 0.0 ? 0.0 : (this.fuel += amount));
    }

    public double calculateFuelForJourney(World level, World destLevel, BlockPos pos, BlockPos destPos) {
        Vector3d posB;
        Vector3d posA;
        double distance;
        double fuel = 0.0;
        if (level != destLevel) {
            fuel = 10.0;
        }
        if ((fuel += (distance = (posA = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_72438_d(posB = new Vector3d((double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p())) / 100.0)) > 100.0) {
            fuel = 100.0;
        }
        return fuel;
    }

    public static class Location {
        private Vector3d pos;
        private String level_loc;
        private Direction direction;
        private transient RegistryKey level;
        private transient BlockPos position;

        public Location(BlockPos pos, RegistryKey<World> level) {
            this.pos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            this.level_loc = level.func_240901_a_().toString();
            this.level = level;
            this.position = pos;
            this.direction = Tardim.RANDOM.nextBoolean() ? Direction.NORTH : (Tardim.RANDOM.nextBoolean() ? Direction.SOUTH : (Tardim.RANDOM.nextBoolean() ? Direction.WEST : Direction.EAST));
        }

        public Location(Location l) {
            this.pos = new Vector3d((double)l.getPos().func_177958_n(), (double)l.getPos().func_177956_o(), (double)l.getPos().func_177952_p());
            this.level_loc = l.level_loc;
            this.level = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.level_loc));
            this.position = new BlockPos(l.getPos().func_177958_n(), l.getPos().func_177956_o(), l.getPos().func_177952_p());
            this.direction = Tardim.RANDOM.nextBoolean() ? Direction.NORTH : (Tardim.RANDOM.nextBoolean() ? Direction.SOUTH : (Tardim.RANDOM.nextBoolean() ? Direction.WEST : Direction.EAST));
        }

        public RegistryKey getLevel() {
            if (this.level == null) {
                this.level = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.level_loc));
            }
            return this.level;
        }

        public BlockPos getPos() {
            if (this.position == null) {
                this.position = new BlockPos(this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c);
            }
            return this.position;
        }

        public Location setPosition(int x, int y, int z) {
            this.pos = new Vector3d((double)x, (double)y, (double)z);
            this.position = new BlockPos(x, y, z);
            return this;
        }

        public Location addPosition(int x, int y, int z) {
            this.position = this.position.func_177982_a(x, y, z);
            this.pos = new Vector3d((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p());
            return this;
        }

        public Location setLocation(RegistryKey<World> level) {
            this.level_loc = level.func_240901_a_().toString();
            this.level = level;
            return this;
        }

        public Location setFacing(Direction d) {
            this.direction = d;
            return this;
        }

        public Direction getFacing() {
            if (this.direction == null) {
                this.direction = Direction.NORTH;
            }
            return this.direction;
        }
    }

    public static class Companion {
        private String username;
        private UUID uuid;

        public Companion(PlayerEntity player) {
            this.username = player.func_146103_bH().getName();
            this.uuid = player.func_146103_bH().getId();
        }

        public String getUsername() {
            return this.username;
        }

        public UUID getUuid() {
            return this.uuid;
        }
    }
}

