/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.tileentity;

import com.swdteam.tardim.common.block.BlockFuelStorage;
import com.swdteam.tardim.common.init.TRDDimensions;
import com.swdteam.tardim.common.init.TRDTiles;
import com.swdteam.tardim.tardim.TardimData;
import com.swdteam.tardim.tardim.TardimManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HopperBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;

public class TileEntityFuelStorage
extends TileEntity
implements ITickableTileEntity {
    private int cooldown = 0;

    public TileEntityFuelStorage() {
        super((TileEntityType)TRDTiles.TILE_FUEL_STORAGE.get());
    }

    public void func_73660_a() {
        TardimData data;
        TileEntityFuelStorage tile = this;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_234923_W_() == TRDDimensions.TARDIS && (data = TardimManager.getFromPos(this.func_174877_v())) != null) {
            int currentFuel = (Integer)this.func_195044_w().func_177229_b((Property)BlockFuelStorage.FUEL_STATE);
            double newFuel = data.getFuel();
            int stateID = tile.getStateIDForLevel(newFuel);
            if (stateID != currentFuel) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockFuelStorage.FUEL_STATE, (Comparable)Integer.valueOf(stateID)), 3);
            }
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c() == Blocks.field_150438_bZ && this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a()).func_177229_b((Property)HopperBlock.field_176430_a) == Direction.DOWN) {
                ++tile.cooldown;
                if (tile.cooldown >= 10) {
                    tile.cooldown = 0;
                    if (data.getFuel() < 100.0) {
                        HopperTileEntity hopper = (HopperTileEntity)this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
                        for (int i = 0; i < hopper.func_70302_i_(); ++i) {
                            ItemStack stack = hopper.func_70301_a(i);
                            double fuel = TardimManager.getFuel(stack.func_77973_b());
                            if (!(fuel > 0.0)) continue;
                            hopper.func_70298_a(i, 1);
                            data.addFuel(fuel);
                            break;
                        }
                    }
                }
            }
        }
    }

    public int getStateIDForLevel(double fuelLevel) {
        int fuel = (int)fuelLevel;
        if (fuel >= 100) {
            return 0;
        }
        if (fuel % 10 > 0) {
            fuel += 10 - fuel % 10;
        }
        switch (fuel) {
            case 100: {
                return 0;
            }
            case 90: {
                return 1;
            }
            case 80: {
                return 2;
            }
            case 70: {
                return 3;
            }
            case 60: {
                return 4;
            }
            case 50: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 30: {
                return 7;
            }
            case 20: {
                return 8;
            }
            case 10: {
                return 9;
            }
        }
        return 9;
    }
}

