/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.tardim.util.world;

import com.google.common.collect.ImmutableMap;
import com.swdteam.tardim.util.world.TileData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class Schematic
implements Serializable {
    public static final long serialVersionUID = -4112363268168080174L;
    public int schem_dim_x;
    public int schem_dim_y;
    public int schem_dim_z;
    public Map<Integer, String> blockTable = new HashMap<Integer, String>();
    public int[] blockMap;
    public List<TileData> tileData = new ArrayList<TileData>();

    public Schematic(int x, int y, int z) {
        this.schem_dim_x = x;
        this.schem_dim_y = y;
        this.schem_dim_z = z;
    }

    public int getBlockID(BlockState tag) {
        String block = Registry.field_212618_g.func_177774_c((Object)tag.func_177230_c()).toString();
        ImmutableMap immutablemap = tag.func_206871_b();
        if (!immutablemap.isEmpty()) {
            for (Map.Entry entry : immutablemap.entrySet()) {
                Property Property2 = (Property)entry.getKey();
                block = block + "," + Property2.func_177701_a() + "=" + this.getName(Property2, (Comparable)entry.getValue());
            }
        }
        if (!this.blockTable.containsValue(block)) {
            int id = this.blockTable.size();
            this.blockTable.put(id, block);
        }
        int id = this.getKeyByValue(this.blockTable, block);
        return id;
    }

    public <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public BlockState getStateFromID(int id) {
        String s = this.blockTable.get(id);
        if (s == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        BlockState state = this.readBlockState(s);
        if (state == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    private BlockState readBlockState(String string) {
        String[] data = string.split(",");
        Block block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(data[0]));
        BlockState blockstate = block.func_176223_P();
        StateContainer stateDefinition = block.func_176194_O();
        for (int i = 1; i < data.length; ++i) {
            String[] s = data[i].split("=");
            String key = s[0];
            String value = s[1];
            Property Property2 = stateDefinition.func_185920_a(key);
            if (Property2 == null) continue;
            blockstate = Schematic.setValueHelper(blockstate, Property2, value);
        }
        return blockstate;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S p_193590_0_, Property<T> p_193590_1_, String blockState) {
        Optional optional = p_193590_1_.func_185929_b(blockState);
        if (optional.isPresent()) {
            return (S)((StateHolder)p_193590_0_.func_206870_a(p_193590_1_, (Comparable)optional.get()));
        }
        return p_193590_0_;
    }

    private <T extends Comparable<T>> String getName(Property<T> p_190010_0_, Comparable<?> p_190010_1_) {
        return p_190010_0_.func_177702_a(p_190010_1_);
    }

    public int getSchemDimX() {
        return this.schem_dim_x;
    }

    public int getSchemDimY() {
        return this.schem_dim_y;
    }

    public int getSchemDimZ() {
        return this.schem_dim_z;
    }

    public List<TileData> getTileData() {
        return this.tileData;
    }

    public void setTileData(List<TileData> tileData) {
        this.tileData = tileData;
    }

    public void setBlockMap(int[] blockMap) {
        this.blockMap = blockMap;
    }
}

