/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepass.config;

import com.mrbysco.telepass.TelePass;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class TeleConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        TelePass.logger.debug("Loaded TelePass' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        TelePass.logger.debug("TelePass' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue goldDurability;
        public final ForgeConfigSpec.IntValue diamondDurability;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            this.goldDurability = builder.comment("Defines the amount of uses the Gold TelePass has [Default: 15]").defineInRange("goldDurability", 15, 0, Integer.MAX_VALUE);
            this.diamondDurability = builder.comment("Defines the amount of uses the Diamond TelePass has [Default: 1000]").defineInRange("diamondDurability", 1000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

