/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepass.item;

import com.mrbysco.telepass.init.TeleGroup;
import com.mrbysco.telepass.item.CompassMaterial;
import com.mrbysco.telepass.util.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ItemTeleCompass
extends Item {
    private final CompassMaterial material;

    public ItemTeleCompass(Item.Properties properties, CompassMaterial material) {
        super(properties.func_200917_a(1).func_200916_a(TeleGroup.TELEPASS).func_200917_a(1).setNoRepair());
        this.material = material;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getMaxUses();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("telepass:ownerName")) {
            String ownerName = itemstack.func_77978_p().func_74779_i("telepass:ownerName");
            if (ownerName.equalsIgnoreCase(playerIn.func_200200_C_().func_150261_e())) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.telepass.self"), Util.field_240973_b_);
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
            }
            boolean isOnline = false;
            for (PlayerEntity player : worldIn.func_217369_A()) {
                if (!player.func_200200_C_().func_150261_e().equalsIgnoreCase(ownerName)) continue;
                isOnline = true;
                break;
            }
            if (isOnline) {
                PlayerEntity owner = PlayerUtil.getPlayerEntityByName(worldIn, ownerName);
                if (owner != null && owner.func_130014_f_().func_234923_W_().getRegistryName() != playerIn.func_130014_f_().func_234923_W_().getRegistryName()) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.telepass.dimension", new Object[]{TextFormatting.RED + ownerName}), Util.field_240973_b_);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_222118_a(1, (LivingEntity)playerIn, p_219998_1_ -> p_219998_1_.func_213334_d(handIn));
                }
                if (!(playerIn instanceof FakePlayer) && owner != null) {
                    worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187544_ad, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 20);
                    playerIn.func_70634_a(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_());
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.telepass.offline", new Object[]{TextFormatting.RED + ownerName}), Util.field_240973_b_);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K && (stack.func_77942_o() && stack.func_77978_p() != null && !stack.func_77978_p().func_74764_b("telepass:ownerName") || !stack.func_77942_o() || stack.func_77978_p() == null)) {
            CompoundNBT tag;
            CompoundNBT compoundNBT = tag = stack.func_77978_p() == null ? new CompoundNBT() : stack.func_77978_p();
            if (entityIn instanceof PlayerEntity && !(entityIn instanceof FakePlayer)) {
                PlayerEntity player = (PlayerEntity)entityIn;
                tag.func_74778_a("telepass:ownerName", player.func_200200_C_().func_150261_e());
                stack.func_77982_d(tag);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("telepass:ownerName")) {
            CompoundNBT tag = stack.func_77978_p();
            String owner = tag.func_74779_i("telepass:ownerName");
            return new StringTextComponent(owner + "'s ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack)));
        }
        return super.func_200295_i(stack);
    }
}

