/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepass.config;

import com.mrbysco.telepass.TelePass;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TeleConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        TelePass.logger.debug("Loaded TelePass' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        TelePass.logger.debug("TelePass' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue goldDurability;
        public final ForgeConfigSpec.IntValue diamondDurability;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.goldDurability = builder.comment("Defines the amount of uses the Gold TelePass has [Default: 15]").defineInRange("goldDurability", 15, 0, Integer.MAX_VALUE);
            this.diamondDurability = builder.comment("Defines the amount of uses the Diamond TelePass has [Default: 1000]").defineInRange("diamondDurability", 1000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

