/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepass.item;

import com.mrbysco.telepass.init.TeleGroup;
import com.mrbysco.telepass.item.CompassMaterial;
import com.mrbysco.telepass.util.PlayerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;

public class ItemTeleCompass
extends Item {
    private final CompassMaterial material;

    public ItemTeleCompass(Item.Properties properties, CompassMaterial material) {
        super(properties.m_41487_(1).m_41491_(TeleGroup.TELEPASS).m_41487_(1).setNoRepair());
        this.material = material;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getMaxUses();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_ && itemstack.m_41782_() && itemstack.m_41783_().m_128441_("telepass:ownerName")) {
            String ownerName = itemstack.m_41783_().m_128461_("telepass:ownerName");
            if (ownerName.equalsIgnoreCase(playerIn.m_7755_().m_6111_())) {
                playerIn.m_6352_((Component)new TranslatableComponent("item.telepass.self"), Util.f_137441_);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
            }
            boolean isOnline = false;
            for (Player player : worldIn.m_6907_()) {
                if (!player.m_7755_().m_6111_().equalsIgnoreCase(ownerName)) continue;
                isOnline = true;
                break;
            }
            if (isOnline) {
                Player owner = PlayerUtil.getPlayerEntityByName(worldIn, ownerName);
                if (owner != null && owner.m_20193_().m_46472_().getRegistryName() != playerIn.m_20193_().m_46472_().getRegistryName()) {
                    playerIn.m_6352_((Component)new TranslatableComponent("item.telepass.dimension", new Object[]{ChatFormatting.RED + ownerName}), Util.f_137441_);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
                }
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41622_(1, (LivingEntity)playerIn, p_219998_1_ -> p_219998_1_.m_21190_(handIn));
                }
                if (!(playerIn instanceof FakePlayer) && owner != null) {
                    worldIn.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11757_, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.f_46441_.nextFloat() * 0.4f + 0.8f));
                    playerIn.m_36335_().m_41524_((Item)this, 20);
                    playerIn.m_6021_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
                }
            } else {
                playerIn.m_6352_((Component)new TranslatableComponent("item.telepass.offline", new Object[]{ChatFormatting.RED + ownerName}), Util.f_137441_);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.f_46443_ && (stack.m_41782_() && stack.m_41783_() != null && !stack.m_41783_().m_128441_("telepass:ownerName") || !stack.m_41782_() || stack.m_41783_() == null)) {
            CompoundTag tag;
            CompoundTag compoundTag = tag = stack.m_41783_() == null ? new CompoundTag() : stack.m_41783_();
            if (entityIn instanceof Player && !(entityIn instanceof FakePlayer)) {
                Player player = (Player)entityIn;
                tag.m_128359_("telepass:ownerName", player.m_7755_().m_6111_());
                stack.m_41751_(tag);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("telepass:ownerName")) {
            CompoundTag tag = stack.m_41783_();
            String owner = tag.m_128461_("telepass:ownerName");
            return new TextComponent(owner + "'s ").m_7220_((Component)new TranslatableComponent(this.m_5671_(stack)));
        }
        return super.m_7626_(stack);
    }
}

