/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.easypaxelmod.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class MoonseekerPaxelItem
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_235336_cN_, Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_235334_I_, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_222401_hJ, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_222446_lj, Blocks.field_222447_lk, Blocks.field_222448_ll, Blocks.field_222449_lm, Blocks.field_222450_ln, Blocks.field_222451_lo, Blocks.field_222452_lp, Blocks.field_222453_lq, Blocks.field_222454_lr, Blocks.field_222455_ls, Blocks.field_222456_lt, Blocks.field_222457_lu, Blocks.field_222458_lv, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150332_K, Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_});
    private static final Set<Material> field_234662_c_ = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).put((Object)Blocks.field_235368_mh_, (Object)Blocks.field_235369_mi_).put((Object)Blocks.field_235370_mj_, (Object)Blocks.field_235371_mk_).put((Object)Blocks.field_235377_mq_, (Object)Blocks.field_235378_mr_).put((Object)Blocks.field_235379_ms_, (Object)Blocks.field_235380_mt_).build();
    protected static final Map<Block, BlockState> SHOVEL_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));

    public MoonseekerPaxelItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super((float)attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder.addToolType(null, tier.func_200925_d()));
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = this.func_200891_e().func_200925_d();
        if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
            return i >= blockIn.getHarvestLevel();
        }
        if (blockIn.getHarvestTool() == ToolType.AXE) {
            return i >= blockIn.getHarvestLevel();
        }
        if (blockIn.getHarvestTool() == ToolType.SHOVEL) {
            return blockIn.func_203425_a(Blocks.field_150433_aE) || blockIn.func_203425_a(Blocks.field_196604_cC);
        }
        Material material = blockIn.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        if (state.getHarvestTool() == ToolType.PICKAXE) {
            return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? super.func_150893_a(stack, state) : this.field_77864_a;
        }
        return field_234662_c_.contains(material) ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockState block = blockstate.getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.AXE);
        PlayerEntity playerentity = context.func_195999_j();
        if (block != null) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, block, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        BlockState blockstate1 = blockstate.getToolModifiedState(world, blockpos, playerentity, context.func_195996_i(), ToolType.SHOVEL);
        BlockState blockstate2 = null;
        if (blockstate1 != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_217378_a((PlayerEntity)null, 1009, blockpos, 0);
            }
            CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate2 != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate2, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220041_1_ -> p_220041_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public static BlockState getShovelPathingState(BlockState originalState) {
        return SHOVEL_LOOKUP.get(originalState.func_177230_c());
    }

    @Nullable
    public static BlockState getAxeStrippingState(BlockState originalState) {
        Block block = BLOCK_STRIPPING_MAP.get(originalState.func_177230_c());
        return block != null ? (BlockState)block.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, originalState.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) : null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Axe, Pickaxe, and Shovel"));
        tooltip.add((ITextComponent)new StringTextComponent("All in One!"));
        tooltip.add((ITextComponent)new StringTextComponent("Regenerates in direct Moonlight."));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        PlayerEntity playerIn = (PlayerEntity)entityIn;
        if (worldIn.func_226690_K_() && !worldIn.field_72995_K) {
            BlockPos blockpos;
            BlockPos blockPos = blockpos = playerIn.func_184187_bx() instanceof BoatEntity ? new BlockPos(playerIn.func_226277_ct_(), (double)Math.round(playerIn.func_226278_cu_()), playerIn.func_226281_cx_()).func_177984_a() : new BlockPos(playerIn.func_226277_ct_(), (double)Math.round(playerIn.func_226278_cu_()), playerIn.func_226281_cx_());
            if (playerIn.field_70170_p.func_226660_f_(blockpos)) {
                stack.func_196085_b(stack.func_77952_i() - 50);
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_234687_u_() {
        return true;
    }
}

