/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.api;

import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.compost.CompostRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.fluid.FluidBlockTransformRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.fluid.FluidOnTopRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.transform.FluidTransformRegistry;
import com.novamachina.exnihilosequentia.common.registries.crook.CrookRegistry;
import com.novamachina.exnihilosequentia.common.registries.crucible.CrucibleRegistry;
import com.novamachina.exnihilosequentia.common.registries.crucible.HeatRegistry;
import com.novamachina.exnihilosequentia.common.registries.defaults.Create;
import com.novamachina.exnihilosequentia.common.registries.defaults.ExNihilo;
import com.novamachina.exnihilosequentia.common.registries.defaults.IDefaultRegistry;
import com.novamachina.exnihilosequentia.common.registries.defaults.ImmersiveEngineerinig;
import com.novamachina.exnihilosequentia.common.registries.defaults.Mekanism;
import com.novamachina.exnihilosequentia.common.registries.defaults.ThermalExpansion;
import com.novamachina.exnihilosequentia.common.registries.hammer.HammerRegistry;
import com.novamachina.exnihilosequentia.common.registries.sieve.SieveRegistry;
import com.novamachina.exnihilosequentia.common.utility.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.ModList;

public class ExNihiloRegistries {
    public static final ModBus BUS = new ModBus();
    public static CrookRegistry CROOK_REGISTRY = new CrookRegistry(BUS);
    public static CompostRegistry COMPOST_REGISTRY = new CompostRegistry(BUS);
    public static HammerRegistry HAMMER_REGISTRY = new HammerRegistry(BUS);
    public static SieveRegistry SIEVE_REGISTRY = new SieveRegistry(BUS);
    public static HeatRegistry HEAT_REGISTRY = new HeatRegistry(BUS);
    public static CrucibleRegistry CRUCIBLE_REGISTRY = new CrucibleRegistry(BUS);
    public static FluidOnTopRegistry FLUID_ON_TOP_REGISTRY = new FluidOnTopRegistry(BUS);
    public static FluidTransformRegistry FLUID_TRANSFORM_REGISTRY = new FluidTransformRegistry(BUS);
    public static FluidBlockTransformRegistry FLUID_BLOCK_REGISTRY = new FluidBlockTransformRegistry(BUS);

    public static class ModBus {
        private final List<AbstractModRegistry> registries = new ArrayList<AbstractModRegistry>();
        private final List<IDefaultRegistry> defaults = new ArrayList<IDefaultRegistry>();

        public ModBus() {
            this.registerDefaults();
        }

        public List<IDefaultRegistry> getDefaults() {
            return this.defaults;
        }

        private void registerDefaults() {
            this.defaults.add(new ExNihilo());
            if (ModList.get().isLoaded("thermalexpansion") || ((Boolean)Config.ENABLE_THERMAL.get()).booleanValue()) {
                this.defaults.add(new ThermalExpansion());
            }
            if (ModList.get().isLoaded("immersiveengineering") || ((Boolean)Config.ENABLE_IMMERSIVE.get()).booleanValue()) {
                this.defaults.add(new ImmersiveEngineerinig());
            }
            if (ModList.get().isLoaded("mekanism") || ((Boolean)Config.ENABLE_MEKANISM.get()).booleanValue()) {
                this.defaults.add(new Mekanism());
            }
            if (ModList.get().isLoaded("create") || ((Boolean)Config.ENABLE_CREATE.get()).booleanValue()) {
                this.defaults.add(new Create());
            }
        }

        public void register(AbstractModRegistry registry) {
            this.registries.add(registry);
        }

        public void clearRegistries() {
            this.registries.forEach(AbstractModRegistry::clear);
        }

        public void useJson() {
            this.useDefault();
            this.registries.forEach(AbstractModRegistry::useJson);
        }

        public void useDefault() {
            this.defaults.forEach(registry -> {
                registry.registerCrook(CROOK_REGISTRY);
                registry.registerCompost(COMPOST_REGISTRY);
                registry.registerHammer(HAMMER_REGISTRY);
                registry.registerSieve(SIEVE_REGISTRY);
                registry.registerHeat(HEAT_REGISTRY);
                registry.registerFiredCrucible(CRUCIBLE_REGISTRY);
                registry.registerWoodCrucible(CRUCIBLE_REGISTRY);
                registry.registerFluidOnTop(FLUID_ON_TOP_REGISTRY);
                registry.registerFluidTransform(FLUID_TRANSFORM_REGISTRY);
                registry.registerFluidBlock(FLUID_BLOCK_REGISTRY);
            });
        }
    }
}

