/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.block;

import com.novamachina.exnihilosequentia.common.block.BaseBlock;
import com.novamachina.exnihilosequentia.common.builder.BlockBuilder;
import com.novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBarrel
extends BaseBlock
implements ITOPInfoProvider {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BlockBarrel(BlockBuilder builder) {
        super(builder);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        AbstractBarrelTile tile = (AbstractBarrelTile)worldIn.func_175625_s(pos);
        if (tile != null) {
            IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElseThrow(() -> new RuntimeException("Missing Fluid Handler"));
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, hit.func_216354_b()).orElseThrow(() -> new RuntimeException("Missing Item Handler"));
            return tile.onBlockActivated(player, handIn, fluidHandler, itemHandler);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData data) {
        AbstractBarrelTile barrelTile = (AbstractBarrelTile)world.func_175625_s(data.getPos());
        if (barrelTile == null) {
            return;
        }
        if (probeMode == ProbeMode.EXTENDED) {
            probeInfo.text(new TranslationTextComponent("top.barrel.mode", new Object[]{barrelTile.getMode().getModeName().toUpperCase()}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        }
        List<ITextComponent> info = barrelTile.getWailaInfo();
        for (ITextComponent tooltip : info) {
            probeInfo.text(tooltip);
        }
    }
}

