/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.block;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.block.BaseBlock;
import com.novamachina.exnihilosequentia.common.builder.BlockBuilder;
import com.novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import com.novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import com.novamachina.exnihilosequentia.common.item.mesh.MeshItem;
import com.novamachina.exnihilosequentia.common.tileentity.sieve.SieveTile;
import com.novamachina.exnihilosequentia.common.utility.Config;
import com.novamachina.exnihilosequentia.common.utility.StringUtils;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockSieve
extends BaseBlock
implements IWaterLoggable,
ITOPInfoProvider {
    public static final EnumProperty<EnumMesh> MESH = EnumProperty.func_177709_a((String)"mesh", EnumMesh.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockSieve() {
        super(new BlockBuilder().properties(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.7f).func_200947_a(SoundType.field_185848_a).func_226896_b_()).harvestLevel(ToolType.AXE, 0).tileEntitySupplier(SieveTile::new));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(MESH, (Comparable)((Object)EnumMesh.NONE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{MESH, WATERLOGGED});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            SieveTile sieveTile = (SieveTile)worldIn.func_175625_s(pos);
            ItemStack stack = player.func_184586_b(handIn);
            for (BlockPos sievePos : this.getNearbySieves(worldIn, pos)) {
                BlockState currentState = worldIn.func_180495_p(sievePos);
                this.activateBlock(currentState, worldIn, player, sievePos, handIn);
            }
            if (stack.func_190926_b() && player.func_225608_bj_()) {
                sieveTile.removeMesh(true);
            } else if (stack.func_77973_b() instanceof MeshItem) {
                sieveTile.insertMesh(stack);
            }
        }
        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
        return ActionResultType.SUCCESS;
    }

    public void activateBlock(BlockState state, World worldIn, PlayerEntity player, BlockPos pos, Hand handIn) {
        BlockItem blockItem;
        ItemStack stack = player.func_184586_b(handIn);
        SieveTile sieveTile = (SieveTile)worldIn.func_175625_s(pos);
        if (sieveTile.isReadyToSieve()) {
            sieveTile.activateSieve((Boolean)state.func_177229_b((IProperty)WATERLOGGED));
        }
        if (!sieveTile.isReadyToSieve() && stack.func_77973_b() instanceof BlockItem && ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable((blockItem = (BlockItem)stack.func_77973_b()).func_179223_d(), sieveTile.getMesh(), (Boolean)state.func_177229_b((IProperty)WATERLOGGED))) {
            sieveTile.insertSiftableBlock(stack);
        }
        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 2);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        SieveTile sieveTile = (SieveTile)world.func_175625_s(iProbeHitData.getPos());
        String block = I18n.func_135052_a((String)sieveTile.getBlockStack().func_77977_a(), (Object[])new Object[0]);
        if (!sieveTile.getBlockStack().func_190926_b()) {
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf(sieveTile.getProgress() / 1.0f))}));
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.sieve.block", new Object[]{block}));
        }
        if (sieveTile.getMesh() != EnumMesh.NONE) {
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.sieve.mesh", new Object[]{sieveTile.getMesh().func_176610_l()}));
        }
    }

    private List<BlockPos> getNearbySieves(World world, BlockPos pos) {
        NonNullList nearbySieves = NonNullList.func_191196_a();
        BlockPos.func_218281_b((BlockPos)new BlockPos(pos.func_177958_n() - (Integer)Config.SIEVE_RANGE.get(), pos.func_177956_o(), pos.func_177952_p() - (Integer)Config.SIEVE_RANGE.get()), (BlockPos)new BlockPos(pos.func_177958_n() + (Integer)Config.SIEVE_RANGE.get(), pos.func_177956_o(), pos.func_177952_p() + (Integer)Config.SIEVE_RANGE.get())).forEach(item -> {
            if (world.func_180495_p(item).func_177230_c() instanceof BlockSieve) {
                nearbySieves.add((Object)new BlockPos((Vec3i)item));
            }
        });
        return nearbySieves;
    }
}

