/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.block;

import com.novamachina.exnihilosequentia.common.block.BaseBlock;
import com.novamachina.exnihilosequentia.common.builder.BlockBuilder;
import com.novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import com.novamachina.exnihilosequentia.common.tileentity.crucible.BaseCrucibleTile;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CrucibleBaseBlock
extends BaseBlock
implements ITOPInfoProvider {
    public CrucibleBaseBlock(BlockBuilder builder) {
        super(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        BaseCrucibleTile tile = (BaseCrucibleTile)worldIn.func_175625_s(pos);
        if (tile != null) {
            IFluidHandler fluidHandler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElseThrow(() -> new RuntimeException("Missing Fluid Handler"));
            return tile.onBlockActivated(player, handIn, fluidHandler);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData data) {
        BaseCrucibleTile crucibleTile = (BaseCrucibleTile)world.func_175625_s(data.getPos());
        if (crucibleTile.getFluidAmount() > 0) {
            String fluidName = I18n.func_135052_a((String)crucibleTile.getFluid().func_207188_f().func_206883_i().func_177230_c().func_149739_a(), (Object[])new Object[0]);
            probeInfo.text((ITextComponent)new TranslationTextComponent("waila.crucible.fluid", new Object[]{fluidName, crucibleTile.getFluidAmount()}));
        }
        if (crucibleTile.getSolidAmount() > 0) {
            probeInfo.text((ITextComponent)new TranslationTextComponent("waila.crucible.solid", new Object[]{crucibleTile.getSolidAmount()}));
        }
    }
}

