/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.block;

import com.novamachina.exnihilosequentia.common.block.BaseBlock;
import com.novamachina.exnihilosequentia.common.builder.BlockBuilder;
import com.novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import com.novamachina.exnihilosequentia.common.init.ModBlocks;
import com.novamachina.exnihilosequentia.common.tileentity.InfestingLeavesTile;
import com.novamachina.exnihilosequentia.common.utility.Config;
import com.novamachina.exnihilosequentia.common.utility.StringUtils;
import java.util.Random;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class InfestingLeavesBlock
extends BaseBlock
implements ITOPInfoProvider {
    public InfestingLeavesBlock() {
        super(new BlockBuilder().properties(Block.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_()).tileEntitySupplier(InfestingLeavesTile::new));
    }

    public static void normalToInfesting(World world, BlockState state, BlockPos pos) {
        world.func_175656_a(pos, ((BaseBlock)ModBlocks.INFESTING_LEAVES.get()).func_176223_P());
    }

    public static void finishInfestingBlock(World world, BlockPos pos) {
        world.func_175656_a(pos, ((BaseBlock)ModBlocks.INFESTED_LEAVES.get()).func_176223_P());
    }

    public static void spread(World world, BlockPos pos) {
        if (!world.func_201670_d()) {
            NonNullList<BlockPos> nearbyLeaves = InfestingLeavesBlock.getNearbyLeaves(world, pos);
            Random random = new Random();
            nearbyLeaves.forEach(leafPos -> {
                if (random.nextDouble() <= (Double)Config.SPREAD_CHANCE.get()) {
                    InfestingLeavesBlock.normalToInfesting(world, world.func_180495_p(leafPos), leafPos);
                }
            });
        }
    }

    private static NonNullList<BlockPos> getNearbyLeaves(World world, BlockPos pos) {
        NonNullList nearbyLeaves = NonNullList.func_191196_a();
        BlockPos.func_218281_b((BlockPos)new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1), (BlockPos)new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1)).forEach(item -> {
            if (world.func_180495_p(item).func_177230_c() instanceof LeavesBlock) {
                nearbyLeaves.add((Object)new BlockPos((Vec3i)item));
            }
        });
        return nearbyLeaves;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        InfestingLeavesTile infestingLeavesTile = (InfestingLeavesTile)world.func_175625_s(iProbeHitData.getPos());
        iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)infestingLeavesTile.getProgress() / 100.0f))}));
    }
}

