/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.compat.jei;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.compost.CompostRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.compost.CompostRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.crook.CrookRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.crook.CrookRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.crucible.CrucibleRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.crucible.CrucibleRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.fluiditem.FluidBlockJEIRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.fluiditem.FluidBlockRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.fluidontop.FluidOnTopJEIRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.fluidontop.FluidOnTopRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.fluidtransform.FluidTransformCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.fluidtransform.FluidTransformJEIRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.hammer.HammerRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.hammer.HammerRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.heat.HeatRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.heat.HeatRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.sieve.SieveRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.sieve.dry.DrySieveRecipeCategory;
import com.novamachina.exnihilosequentia.common.compat.jei.sieve.wet.WetSieveRecipeCategory;
import com.novamachina.exnihilosequentia.common.init.ModBlocks;
import com.novamachina.exnihilosequentia.common.item.tools.crook.EnumCrook;
import com.novamachina.exnihilosequentia.common.item.tools.hammer.EnumHammer;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "exnihilosequentia");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CrookRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DrySieveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WetSieveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidTransformCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidBlockRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "crucible_wood")});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "crucible_fired")});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.registerCrook(registration);
        this.registerSieve(registration);
        this.registerHammer(registration);
        this.registerFluidOnTop(registration);
        this.registerFluidTransform(registration);
        this.registerFluidBlock(registration);
        this.registerCompost(registration);
        this.registerFiredCrucible(registration);
        this.registerWoodCrucible(registration);
        this.registerHeat(registration);
    }

    private void registerHeat(IRecipeRegistration registration) {
        List<HeatRecipe> recipes = ExNihiloRegistries.HEAT_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, HeatRecipeCategory.UID);
        LogUtil.info("JEI: Heat Recipes Loaded: " + recipes.size());
    }

    private void registerWoodCrucible(IRecipeRegistration registration) {
        List<CrucibleRecipe> recipes = ExNihiloRegistries.CRUCIBLE_REGISTRY.getWoodRecipeList();
        registration.addRecipes(recipes, new ResourceLocation("exnihilosequentia", "crucible_wood"));
        LogUtil.info("JEI: Wooden Crucible Recipes Loaded: " + recipes.size());
    }

    private void registerFiredCrucible(IRecipeRegistration registration) {
        List<CrucibleRecipe> recipes = ExNihiloRegistries.CRUCIBLE_REGISTRY.getFiredRecipeList();
        registration.addRecipes(recipes, new ResourceLocation("exnihilosequentia", "crucible_fired"));
        LogUtil.info("JEI: Fired Crucible Recipes Loaded: " + recipes.size());
    }

    private void registerCompost(IRecipeRegistration registration) {
        List<CompostRecipe> recipes = ExNihiloRegistries.COMPOST_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, CompostRecipeCategory.UID);
        LogUtil.info("JEI: Compost Recipes Loaded: " + recipes.size());
    }

    private void registerFluidBlock(IRecipeRegistration registration) {
        List<FluidBlockJEIRecipe> recipes = ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FluidBlockRecipeCategory.UID);
        LogUtil.info("JEI: Fluid Item Recipes Loaded: " + recipes.size());
    }

    private void registerFluidTransform(IRecipeRegistration registration) {
        List<FluidTransformJEIRecipe> recipes = ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FluidTransformCategory.UID);
        LogUtil.info("JEI: Fluid Transform Recipes Loaded: " + recipes.size());
    }

    private void registerFluidOnTop(IRecipeRegistration registration) {
        List<FluidOnTopJEIRecipe> recipes = ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FluidOnTopRecipeCategory.UID);
        LogUtil.info("JEI: Fluid On Top Recipes Loaded: " + recipes.size());
    }

    private void registerHammer(IRecipeRegistration registration) {
        List<HammerRecipe> recipes = ExNihiloRegistries.HAMMER_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, HammerRecipeCategory.UID);
        LogUtil.info("JEI: Hammer Recipes Loaded: " + recipes.size());
    }

    private void registerSieve(IRecipeRegistration registration) {
        List<SieveRecipe> drySieveRecipes = ExNihiloRegistries.SIEVE_REGISTRY.getDryRecipeList();
        List<SieveRecipe> wetSieveRecipes = ExNihiloRegistries.SIEVE_REGISTRY.getWetRecipeList();
        registration.addRecipes(drySieveRecipes, DrySieveRecipeCategory.UID);
        registration.addRecipes(wetSieveRecipes, WetSieveRecipeCategory.UID);
        LogUtil.info("JEI: Sieve Recipes Loaded: " + (drySieveRecipes.size() + wetSieveRecipes.size()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (EnumCrook enumCrook : EnumCrook.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)enumCrook.getRegistryObject().get()), new ResourceLocation[]{CrookRecipeCategory.UID});
        }
        for (Enum enum_ : EnumHammer.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((EnumHammer)enum_).getRegistryObject().get()), new ResourceLocation[]{HammerRecipeCategory.UID});
        }
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.SIEVE.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.SIEVE.get()), new ResourceLocation[]{WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BARREL_WOOD.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BARREL_WOOD.get()), new ResourceLocation[]{FluidTransformCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BARREL_WOOD.get()), new ResourceLocation[]{FluidBlockRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.BARREL_WOOD.get()), new ResourceLocation[]{CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CRUCIBLE_FIRED.get()), new ResourceLocation[]{new ResourceLocation("exnihilosequentia", "crucible_fired")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CRUCIBLE_WOOD.get()), new ResourceLocation[]{new ResourceLocation("exnihilosequentia", "crucible_wood")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CRUCIBLE_FIRED.get()), new ResourceLocation[]{HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CRUCIBLE_WOOD.get()), new ResourceLocation[]{HeatRecipeCategory.UID});
    }

    private void registerCrook(IRecipeRegistration registration) {
        List<CrookRecipe> crookRecipes = ExNihiloRegistries.CROOK_REGISTRY.getRecipeList();
        registration.addRecipes(crookRecipes, CrookRecipeCategory.UID);
        LogUtil.info("JEI: Crook Recipes Loaded: " + crookRecipes.size());
    }
}

