/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.compat.jei.compost;

import com.novamachina.exnihilosequentia.common.compat.jei.compost.CompostRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.compost.CompostTooltipCallback;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CompostRecipeCategory
implements IRecipeCategory<CompostRecipe> {
    private static final ResourceLocation texture = new ResourceLocation("exnihilosequentia", "textures/gui/jei_mid.png");
    public static ResourceLocation UID = new ResourceLocation("exnihilosequentia", "compost");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public CompostRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 112, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CompostRecipe> getRecipeClass() {
        return CompostRecipe.class;
    }

    public String getTitle() {
        return "Compost";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(CompostRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getInputs());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CompostRecipe recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 38);
        recipeLayout.getItemStacks().set(0, recipe.getOutput());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 1;
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack stack = recipe.getInputs().get(i);
            recipeLayout.getItemStacks().init(i + slotIndex, true, slotX, slotY);
            recipeLayout.getItemStacks().set(i + slotIndex, stack);
            if (focus == null || !stack.func_77969_a((ItemStack)focus.getValue())) continue;
            recipeLayout.getItemStacks().setBackground(i + slotIndex, (IDrawable)this.slotHighlight);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new CompostTooltipCallback());
    }
}

