/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.compat.jei.crook;

import com.novamachina.exnihilosequentia.common.compat.jei.crook.CrookRecipe;
import com.novamachina.exnihilosequentia.common.compat.jei.crook.CrookTooltipCallback;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CrookRecipeCategory
implements IRecipeCategory<CrookRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "crook");
    private static final ResourceLocation texture = new ResourceLocation("exnihilosequentia", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public CrookRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 112, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrookRecipe> getRecipeClass() {
        return CrookRecipe.class;
    }

    public String getTitle() {
        return "Crook";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(CrookRecipe crookRecipe, IIngredients iIngredients) {
        iIngredients.setInputs(VanillaTypes.ITEM, crookRecipe.getInputs());
        iIngredients.setOutputs(VanillaTypes.ITEM, crookRecipe.getOutputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrookRecipe crookRecipe, IIngredients iIngredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 38);
        recipeLayout.getItemStacks().set(0, crookRecipe.getInputs());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 1;
        for (int i = 0; i < crookRecipe.getOutputs().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack outputStack = crookRecipe.getOutputs().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            if (focus == null) continue;
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack.func_190926_b() || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            recipeLayout.getItemStacks().setBackground(i + slotIndex, (IDrawable)this.slotHighlight);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new CrookTooltipCallback(crookRecipe));
    }
}

