/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.item.dolls;

import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;

public enum DollEnum {
    BLAZE("minecraft", "blaze", "minecraft", "lava", 1.0, "tooltip.doll.blaze"),
    ENDERMAN("minecraft", "enderman", "exnihilosequentia", "witchwater", 2.0, "tooltip.doll.enderman"),
    SHULKER("minecraft", "shulker", "exnihilosequentia", "witchwater", 1.5, "tooltip.doll.shulker"),
    GUARDIAN("minecraft", "guardian", "exnihilosequentia", "sea_water", 1.0, "tooltip.doll.guardian"),
    BEE("minecraft", "bee", "exnihilosequentia", "witchwater", 1.0, "tooltip.doll.bee");

    private final String entityModId;
    private final String entityName;
    private final String fluidModId;
    private final String fluidName;
    private final double yOffset;
    private final String tooltip;
    private RegistryObject<Item> registryObject;

    private DollEnum(String entityModId, String entityName, String fluidModId, String fluidName, double yOffset, String tooltip) {
        this.entityModId = entityModId;
        this.entityName = entityName;
        this.fluidModId = fluidModId;
        this.fluidName = fluidName;
        this.yOffset = yOffset;
        this.tooltip = tooltip;
    }

    public static DollEnum getDollFromString(String dollName) {
        for (DollEnum doll : DollEnum.values()) {
            if (!doll.name().toLowerCase().equals(dollName)) continue;
            return doll;
        }
        return null;
    }

    public String getFluidModId() {
        return this.fluidModId;
    }

    public String getEntityModId() {
        return this.entityModId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getFluidName() {
        return this.fluidName;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public String getDollName() {
        return "doll_" + this.entityName;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public RegistryObject<Item> getRegistryObject() {
        return this.registryObject;
    }

    public void setRegistryObject(RegistryObject<Item> registryObject) {
        this.registryObject = registryObject;
    }
}

