/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.item.seeds;

import com.novamachina.exnihilosequentia.common.init.ModInitialization;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SeedBaseItem
extends Item
implements IPlantable {
    private final BlockState plant;
    private PlantType type;

    public SeedBaseItem(BlockState plant) {
        super(new Item.Properties().func_200916_a(ModInitialization.ITEM_GROUP));
        this.plant = plant;
    }

    public SeedBaseItem setPlantType(PlantType type) {
        this.type = type;
        return this;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return this.type;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.plant;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_196000_l().equals((Object)Direction.UP)) {
            return ActionResultType.PASS;
        }
        ItemStack item = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        World world = context.func_195991_k();
        if (player.func_175151_a(pos, direction, item) && player.func_175151_a(pos.func_177982_a(0, 1, 0), direction, item)) {
            BlockState soil = this.type == PlantType.Water ? world.func_180495_p(context.func_195995_a().func_177982_a(0, 1, 0)) : world.func_180495_p(context.func_195995_a());
            boolean canSustain = soil.func_177230_c().canSustainPlant(soil, (IBlockReader)world, pos, Direction.UP, (IPlantable)this);
            boolean blockEmpty = this.isBlockSpaceEmpty(world, pos, this.type);
            if (canSustain && blockEmpty && this.getPlant((IBlockReader)world, pos) != null) {
                world.func_175656_a(pos.func_177982_a(0, 1, 0), this.getPlant((IBlockReader)world, pos));
                if (!player.func_184812_l_()) {
                    item.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private boolean isBlockSpaceEmpty(World world, BlockPos pos, PlantType type) {
        if (type == PlantType.Water) {
            return world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() == Blocks.field_150355_j;
        }
        return world.func_175623_d(pos.func_177982_a(0, 1, 0));
    }
}

