/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.item.tools.crook;

import com.google.common.collect.Sets;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.block.InfestedLeavesBlock;
import com.novamachina.exnihilosequentia.common.init.ModInitialization;
import com.novamachina.exnihilosequentia.common.item.resources.EnumResource;
import com.novamachina.exnihilosequentia.common.registries.crook.CrookDropEntry;
import com.novamachina.exnihilosequentia.common.utility.Config;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class CrookBaseItem
extends ToolItem {
    private static final Set<Block> effectiveBlocksOn = Sets.newHashSet((Iterable)BlockTags.field_206952_E.func_199885_a());

    public CrookBaseItem(IItemTier tier, int maxDamage) {
        super(0.5f, 0.5f, tier, effectiveBlocksOn, new Item.Properties().func_200915_b(maxDamage).func_200916_a(ModInitialization.ITEM_GROUP));
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Random random;
        super.func_179218_a(stack, worldIn, state, pos, entityLiving);
        ArrayList<ItemStack> itemDrops = new ArrayList<ItemStack>();
        Collection<ResourceLocation> tags = TagUtils.getTags(state.func_177230_c());
        if (tags.contains(new ResourceLocation("minecraft:leaves"))) {
            for (int i = 0; i < (Integer)Config.VANILLA_SIMULATE_DROP_COUNT.get(); ++i) {
                List items = Block.func_220070_a((BlockState)state, (ServerWorld)worldIn.func_73046_m().func_71218_a(worldIn.func_201675_m().func_186058_p()), (BlockPos)pos, null);
                itemDrops.addAll(items);
            }
            random = new Random();
            for (CrookDropEntry entry : ExNihiloRegistries.CROOK_REGISTRY.getDrops()) {
                if (!(random.nextFloat() <= entry.getRarity())) continue;
                itemDrops.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry.getItem())));
            }
        }
        if (state.func_177230_c() instanceof InfestedLeavesBlock) {
            random = new Random();
            itemDrops.add(new ItemStack((IItemProvider)Items.field_151007_F, random.nextInt((Integer)Config.MAX_BONUS_STRING_COUNT.get()) + (Integer)Config.MIN_STRING_COUNT.get()));
            if (random.nextDouble() <= 0.8) {
                itemDrops.add(new ItemStack((IItemProvider)EnumResource.SILKWORM.getRegistryObject().get()));
            }
        }
        for (ItemStack item : itemDrops) {
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), item));
        }
        return false;
    }
}

