/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.novamachina.exnihilosequentia.common.json.JsonRequired;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;

public class AnnotatedDeserializer<T>
implements JsonDeserializer<T> {
    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object pojo = new Gson().fromJson(json, typeOfT);
        this.checkRequiredFields(pojo.getClass().getDeclaredFields(), pojo);
        this.checkSuperClasses(pojo);
        return (T)pojo;
    }

    private void checkRequiredFields(Field[] fields, Object pojo) throws JsonParseException {
        if (pojo instanceof List) {
            List pojoList = (List)pojo;
            for (Object pojoListPojo : pojoList) {
                this.checkRequiredFields(pojoListPojo.getClass().getDeclaredFields(), pojoListPojo);
                this.checkSuperClasses(pojoListPojo);
            }
        }
        for (Field f : fields) {
            if (f.getAnnotation(JsonRequired.class) == null) continue;
            try {
                f.setAccessible(true);
                Object fieldObject = f.get(pojo);
                if (fieldObject == null) {
                    throw new JsonParseException(String.format("Missing field: %1$s -> %2$s", pojo.getClass().getSimpleName(), f.getName()));
                }
                this.checkRequiredFields(fieldObject.getClass().getDeclaredFields(), fieldObject);
                this.checkSuperClasses(fieldObject);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    private void checkSuperClasses(Object pojo) throws JsonParseException {
        Class<?> superclass = pojo.getClass();
        while ((superclass = superclass.getSuperclass()) != null) {
            this.checkRequiredFields(superclass.getDeclaredFields(), pojo);
        }
    }
}

