/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;

public abstract class AbstractModRegistry {
    public abstract void clear();

    public abstract List toJSONReady();

    public abstract void useJson();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean generateJson(String fileName, AbstractModRegistry registry) {
        File file = Constants.Json.baseJsonPath.resolve(fileName).toFile();
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            registry.clear();
            return false;
        }
        if (Files.exists(file.toPath(), new LinkOption[0])) return false;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        List list = registry.toJSONReady();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(gson.toJson((Object)list));
            LogUtil.info("Created " + fileName);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

