/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.barrel.compost;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.compost.CompostRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.CompostJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;

public class CompostRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, Integer> solidsMap = new HashMap<ResourceLocation, Integer>();

    public CompostRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public boolean containsSolid(IItemProvider item) {
        Collection<ResourceLocation> tags = TagUtils.getTags(item);
        for (ResourceLocation tag : tags) {
            if (!this.solidsMap.containsKey(tag)) continue;
            return true;
        }
        return this.solidsMap.containsKey(item.func_199767_j().getRegistryName());
    }

    public int getSolidAmount(IItemProvider item) {
        Collection<ResourceLocation> tags = TagUtils.getTags(item);
        for (ResourceLocation tag : tags) {
            if (!this.solidsMap.containsKey(tag)) continue;
            return this.solidsMap.get(tag);
        }
        return this.solidsMap.getOrDefault(item.func_199767_j().getRegistryName(), 0);
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.COMPOST_FILE, this)) {
            return;
        }
        try {
            List<CompostJson> registryJson = this.readJson();
            for (CompostJson entry : registryJson) {
                try {
                    if (this.itemExists(entry.getEntry())) {
                        this.solidsMap.put(new ResourceLocation(entry.getEntry()), entry.getAmount());
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.COMPOST_FILE, entry.getEntry()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.COMPOST_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.COMPOST_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerCompost(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID);
    }

    private List<CompostJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<CompostJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.COMPOST_FILE);
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    public void addSolid(IItemProvider item, int solidAmount) {
        this.addSolid(item.func_199767_j().getRegistryName(), solidAmount);
    }

    public void addSolid(ResourceLocation tag, int solidAmount) {
        List<ResourceLocation> idList = TagUtils.getTagsOwnedBy(tag);
        for (ResourceLocation id : idList) {
            if (!this.solidsMap.containsKey(id)) continue;
            LogUtil.info(String.format("ID: %s falls under Tag: %s. Removing %s ...", id.toString(), tag.toString(), id.toString()));
            this.solidsMap.remove(id);
        }
        Collection<ResourceLocation> tags = TagUtils.getTags(tag);
        if (tags != null) {
            for (ResourceLocation id : tags) {
                if (!this.solidsMap.containsKey(id)) continue;
                LogUtil.info(String.format("Tag: %s already registered. Skipping item %s ...", id.toString(), tag));
                return;
            }
        }
        if (this.solidsMap.containsKey(tag)) {
            LogUtil.info(String.format("Tag: %s already registered. Skipping...", tag));
            return;
        }
        this.insertIntoMap(tag, solidAmount);
    }

    private void insertIntoMap(ResourceLocation id, int amount) {
        this.solidsMap.put(id, amount);
    }

    @Override
    public void clear() {
        this.solidsMap.clear();
    }

    @Override
    public List<CompostJson> toJSONReady() {
        ArrayList<CompostJson> gsonList = new ArrayList<CompostJson>();
        for (Map.Entry<ResourceLocation, Integer> entry : this.solidsMap.entrySet()) {
            gsonList.add(new CompostJson(entry.getKey().toString(), entry.getValue()));
        }
        return gsonList;
    }

    public List<CompostRecipe> getRecipeList() {
        ArrayList<CompostRecipe> recipes = new ArrayList<CompostRecipe>();
        for (ResourceLocation entry : this.solidsMap.keySet()) {
            ArrayList<ItemStack> blocks;
            Tag itemTag = ItemTags.func_199903_a().func_199910_a(entry);
            if (itemTag != null) {
                blocks = itemTag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList());
            } else {
                blocks = new ArrayList<ItemStack>();
                blocks.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry)));
            }
            recipes.add(new CompostRecipe(blocks, new ItemStack((IItemProvider)Blocks.field_150346_d)));
        }
        return recipes;
    }
}

