/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.barrel.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.fluiditem.FluidBlockJEIRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.FluidBlockJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.fluid.FluidBlockTransformRecipe;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidBlockTransformRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, List<FluidBlockTransformRecipe>> recipeMap = new HashMap<ResourceLocation, List<FluidBlockTransformRecipe>>();

    public FluidBlockTransformRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public boolean isValidRecipe(Fluid fluid, Item input) {
        List<FluidBlockTransformRecipe> possibleRecipes = this.recipeMap.get(fluid.getRegistryName());
        if (possibleRecipes == null) {
            return false;
        }
        for (FluidBlockTransformRecipe recipe : possibleRecipes) {
            if (!recipe.getInput().equals((Object)input.getRegistryName())) continue;
            return true;
        }
        return false;
    }

    public IItemProvider getResult(Fluid fluid, Item input) {
        List<FluidBlockTransformRecipe> possibleRecipes = this.recipeMap.get(fluid.getRegistryName());
        for (FluidBlockTransformRecipe recipe : possibleRecipes) {
            if (!recipe.getInput().equals((Object)input.getRegistryName())) continue;
            return (IItemProvider)ForgeRegistries.ITEMS.getValue(recipe.getResult());
        }
        return null;
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.FLUID_BLOCK_FILE, this)) {
            return;
        }
        try {
            List<FluidBlockJson> registriesJson = this.readJson();
            for (FluidBlockJson entry : registriesJson) {
                try {
                    if (this.itemExists(entry.getFluid())) {
                        ResourceLocation fluidID = new ResourceLocation(entry.getFluid());
                        if (this.itemExists(entry.getInput())) {
                            ResourceLocation inputID = new ResourceLocation(entry.getInput());
                            if (this.itemExists(entry.getResult())) {
                                ResourceLocation resultID = new ResourceLocation(entry.getResult());
                                this.addRecipe(fluidID, inputID, resultID);
                                continue;
                            }
                            LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_BLOCK_FILE, entry.getResult()));
                            continue;
                        }
                        LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_BLOCK_FILE, entry.getInput()));
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_BLOCK_FILE, entry.getFluid()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.FLUID_BLOCK_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.FLUID_BLOCK_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerFluidBlock(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID) || ForgeRegistries.FLUIDS.containsKey(itemID);
    }

    private List<FluidBlockJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<FluidBlockJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.FLUID_BLOCK_FILE);
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    public void addRecipe(ResourceLocation fluid, ResourceLocation input, ResourceLocation result) {
        List<FluidBlockTransformRecipe> list = this.recipeMap.get(fluid);
        if (list == null) {
            list = new ArrayList<FluidBlockTransformRecipe>();
            this.recipeMap.put(fluid, list);
        }
        for (FluidBlockTransformRecipe recipe : list) {
            if (!recipe.getInput().equals((Object)input)) continue;
            LogUtil.info(String.format("Duplicate recipe: %s(Fluid) + %s(Input). Keeping first result: %s", fluid, input, recipe.getResult().toString()));
        }
        list.add(new FluidBlockTransformRecipe(fluid, input, result));
    }

    public void addRecipe(Fluid fluid, IItemProvider input, Block result) {
        this.addRecipe(fluid.getRegistryName(), input.func_199767_j().getRegistryName(), result.getRegistryName());
    }

    @Override
    public void clear() {
        this.recipeMap.clear();
    }

    @Override
    public List<FluidBlockJson> toJSONReady() {
        ArrayList<FluidBlockJson> gsonList = new ArrayList<FluidBlockJson>();
        for (List<FluidBlockTransformRecipe> recipeList : this.recipeMap.values()) {
            for (FluidBlockTransformRecipe recipe : recipeList) {
                gsonList.add(new FluidBlockJson(recipe));
            }
        }
        return gsonList;
    }

    public List<FluidBlockJEIRecipe> getRecipeList() {
        ArrayList<FluidBlockJEIRecipe> recipes = new ArrayList<FluidBlockJEIRecipe>();
        for (List<FluidBlockTransformRecipe> recipeList : this.recipeMap.values()) {
            for (FluidBlockTransformRecipe recipe : recipeList) {
                FluidStack fluidInBarrel = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getFluid()), 1000);
                ItemStack input = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(recipe.getInput()));
                ItemStack result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(recipe.getResult()));
                recipes.add(new FluidBlockJEIRecipe(fluidInBarrel, input, result));
            }
        }
        return recipes;
    }
}

